/*
 * Decompiled with CFR 0.152.
 */
package org.robovm.debugger;

import java.io.File;
import org.robovm.debugger.DebuggerConfig;
import org.robovm.debugger.delegates.AllDelegates;
import org.robovm.debugger.hooks.HooksChannel;
import org.robovm.debugger.hooks.IHooksApi;
import org.robovm.debugger.hooks.IHooksEventsHandler;
import org.robovm.debugger.hooks.payloads.HooksEventPayload;
import org.robovm.debugger.jdwp.IJdwpServerApi;
import org.robovm.debugger.jdwp.IJdwpServerDelegate;
import org.robovm.debugger.jdwp.JdwpDebugServer;
import org.robovm.debugger.state.VmDebuggerState;
import org.robovm.debugger.utils.DbgLogger;
import org.robovm.debugger.utils.DebuggerThread;

public class Debugger
implements DebuggerThread.Catcher,
IHooksEventsHandler,
IJdwpServerDelegate {
    private final DbgLogger log;
    private final Process process;
    private final DebuggerConfig config;
    private final AllDelegates delegates;
    private final VmDebuggerState state;
    private final JdwpDebugServer jdwpServer;
    private final HooksChannel hooksChannel;
    private volatile boolean shuttingDown;

    public Debugger(Process process, DebuggerConfig config) {
        File logFile = config.logDir() != null ? new File(config.logDir(), "debugger" + System.currentTimeMillis() + ".log") : null;
        DbgLogger.setup(logFile, config.logToConsole());
        this.log = DbgLogger.get(this.getClass().getSimpleName());
        this.process = process;
        this.config = config;
        this.state = new VmDebuggerState(config.appfile(), config.arch());
        this.delegates = new AllDelegates(this, this.state);
        this.jdwpServer = new JdwpDebugServer(this.delegates, this, config.jdwpClienMode(), config.jdwpPort());
        this.hooksChannel = new HooksChannel(this.delegates, !config.arch().is32Bit(), config.hooksConnection(), this);
    }

    public void start() {
        this.jdwpServer.start();
        this.hooksChannel.start();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void shutdown() {
        Debugger debugger = this;
        synchronized (debugger) {
            if (this.shuttingDown) {
                return;
            }
            this.shuttingDown = true;
        }
        this.delegates.shutdown();
        this.jdwpServer.shutdown();
        this.hooksChannel.shutdown();
        if (this.config.isStandalone()) {
            System.exit(-1);
        }
        if (this.process != null && this.process.isAlive()) {
            this.process.destroy();
        }
    }

    @Override
    public void onJdwpHandshakeComplete(IJdwpServerApi api) {
        this.delegates.onConnectedToJdwp(api);
    }

    @Override
    public void onHooksTargetAttached(IHooksApi api, long robovmBaseSymbol) {
        long robovmBaseSymbolMachO = this.state.appFileLoader().resolveSymbol("robovmBaseSymbol");
        long runtimeMemoryOffset = robovmBaseSymbol - robovmBaseSymbolMachO;
        this.delegates.onConnectedToTarget(api, runtimeMemoryOffset);
    }

    @Override
    public void onHooksTargetEvent(HooksEventPayload eventPayload) {
        this.delegates.events().postEventFromHooks(eventPayload);
    }

    @Override
    public void onException(Thread thread, Throwable t) {
        this.log.error("Thread " + thread.getName() + " crashed", t);
        this.shutdown();
    }

    public static void main(String[] argv) throws InterruptedException {
        DebuggerConfig config = DebuggerConfig.fromCommandLine(argv);
        Debugger debugger = new Debugger(null, config);
        debugger.start();
        Thread.sleep(Long.MAX_VALUE);
    }
}

