/*
 * Decompiled with CFR 0.152.
 */
package org.robovm.debugger.debuginfo;

import java.io.ByteArrayOutputStream;
import java.io.DataOutputStream;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.PrintWriter;
import java.nio.ByteOrder;
import java.util.HashMap;
import java.util.Map;
import org.robovm.debugger.debuginfo.DebuggerDebugAllocaInfo;
import org.robovm.debugger.debuginfo.DebuggerDebugMethodInfo;
import org.robovm.debugger.debuginfo.DebuggerDebugVariableInfo;
import org.robovm.debugger.utils.bytebuffer.DataBufferReader;

public class DebuggerDebugObjectFileInfo {
    private final String sourceFile;
    private final DebuggerDebugMethodInfo[] methods;
    private Map<String, DebuggerDebugMethodInfo> methodBySignature;

    public DebuggerDebugObjectFileInfo(String sourceFile, DebuggerDebugMethodInfo.RawData[] rawMethods) {
        this.sourceFile = sourceFile;
        this.methods = new DebuggerDebugMethodInfo[rawMethods.length];
        for (int idx = 0; idx < this.methods.length; ++idx) {
            this.methods[idx] = new DebuggerDebugMethodInfo(rawMethods[idx]);
        }
    }

    public String sourceFile() {
        return this.sourceFile;
    }

    public DebuggerDebugMethodInfo[] methods() {
        return this.methods;
    }

    public DebuggerDebugMethodInfo methodBySignature(String signature) {
        if (this.methodBySignature == null) {
            this.methodBySignature = new HashMap<String, DebuggerDebugMethodInfo>();
            for (DebuggerDebugMethodInfo methodInfo : this.methods()) {
                this.methodBySignature.put(methodInfo.signature(), methodInfo);
            }
        }
        return this.methodBySignature.get(signature);
    }

    public static byte[] dumpDebugInfo(RawData debugInfo) throws IOException {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        try (DataOutputStream stream = new DataOutputStream(baos);){
            DebuggerDebugObjectFileInfo.putStringWithLen(stream, debugInfo.sourceFile);
            stream.writeInt(debugInfo.methods.length);
            for (DebuggerDebugMethodInfo.RawData methodInfo : debugInfo.methods) {
                DebuggerDebugObjectFileInfo.putStringWithLen(stream, methodInfo.signature);
                stream.writeInt(methodInfo.startLine);
                stream.writeInt(methodInfo.finalLine);
                stream.writeInt(methodInfo.spFpOffset);
                stream.writeInt(methodInfo.variables.length);
                for (DebuggerDebugVariableInfo varInfo : methodInfo.variables) {
                    DebuggerDebugObjectFileInfo.putStringWithLen(stream, varInfo.name());
                    DebuggerDebugObjectFileInfo.putStringWithLen(stream, varInfo.typeSignature());
                    stream.writeByte(varInfo.isArgument() ? 1 : 0);
                    stream.writeInt(varInfo.startLine());
                    stream.writeInt(varInfo.finalLine());
                }
                stream.writeInt(methodInfo.allocas.length);
                for (DebuggerDebugAllocaInfo alloca : methodInfo.allocas) {
                    stream.writeInt(alloca.register());
                    stream.writeInt(alloca.offset());
                }
                stream.writeInt(methodInfo.slices.length);
                for (int[] slice : methodInfo.slices) {
                    stream.writeInt(slice.length);
                    for (int v : slice) {
                        stream.writeInt(v);
                    }
                }
                stream.writeInt(methodInfo.offsets.length);
                for (int v : methodInfo.offsets) {
                    stream.writeInt(v);
                }
                for (int v : methodInfo.offsetSliceIndexes) {
                    stream.writeInt(v);
                }
            }
        }
        return baos.toByteArray();
    }

    public static DebuggerDebugObjectFileInfo readDebugInfo(DataBufferReader buffer) {
        buffer.setByteOrder(ByteOrder.BIG_ENDIAN);
        String sourceFile = buffer.readStringWithLen();
        int methodCount = buffer.readInt32();
        DebuggerDebugMethodInfo.RawData[] methods = new DebuggerDebugMethodInfo.RawData[methodCount];
        for (int methodIdx = 0; methodIdx < methodCount; ++methodIdx) {
            int idx;
            String methodSignature = buffer.readStringWithLen();
            int methodStartLine = buffer.readInt32();
            int methodEndLine = buffer.readInt32();
            int spfpOffset = buffer.readInt32();
            int count = buffer.readInt32();
            DebuggerDebugVariableInfo[] variables = new DebuggerDebugVariableInfo[count];
            for (int idx2 = 0; idx2 < count; ++idx2) {
                String varName = buffer.readStringWithLen();
                String varSignature = buffer.readStringWithLen();
                int flags = buffer.readByte() & 0xFF;
                int varStartLine = buffer.readInt32();
                int varEndLine = buffer.readInt32();
                variables[idx2] = new DebuggerDebugVariableInfo(varName, varSignature, (flags & 1) == 1, varStartLine, varEndLine);
            }
            count = buffer.readInt32();
            DebuggerDebugAllocaInfo[] allocas = new DebuggerDebugAllocaInfo[count];
            for (int idx3 = 0; idx3 < count; ++idx3) {
                int register = buffer.readInt32();
                int offset = buffer.readInt32();
                allocas[idx3] = new DebuggerDebugAllocaInfo(register, offset);
            }
            count = buffer.readInt32();
            int[][] slices = new int[count][];
            for (int idx4 = 0; idx4 < count; ++idx4) {
                int sliceSize = buffer.readInt32();
                int[] slice = new int[sliceSize];
                slices[idx4] = slice;
                for (int i = 0; i < sliceSize; ++i) {
                    slice[i] = buffer.readInt32();
                }
            }
            count = buffer.readInt32();
            int[] offsets = new int[count];
            int[] offsetSliceIndexes = new int[count];
            for (idx = 0; idx < count; ++idx) {
                offsets[idx] = buffer.readInt32();
            }
            for (idx = 0; idx < count; ++idx) {
                offsetSliceIndexes[idx] = buffer.readInt32();
            }
            methods[methodIdx] = new DebuggerDebugMethodInfo.RawData(methodSignature, methodStartLine, methodEndLine, spfpOffset, variables, allocas, offsets, offsetSliceIndexes, slices);
        }
        return new DebuggerDebugObjectFileInfo(sourceFile, methods);
    }

    public static void dumpDebugInfoAsText(RawData debugInfo, File file) {
        try (PrintWriter pw = new PrintWriter(file);){
            for (DebuggerDebugMethodInfo.RawData methodInfo : debugInfo.methods) {
                pw.println(methodInfo.signature + " @(" + methodInfo.startLine + ":" + methodInfo.finalLine + ")");
                for (DebuggerDebugVariableInfo variableInfo : methodInfo.variables) {
                    pw.println(variableInfo.name() + "/" + variableInfo.typeSignature() + " @(" + variableInfo.startLine() + ":" + variableInfo.finalLine() + ")");
                }
                pw.println();
            }
        }
        catch (FileNotFoundException fileNotFoundException) {
            // empty catch block
        }
    }

    private static void putStringWithLen(DataOutputStream stream, String str) throws IOException {
        stream.writeInt(str.length());
        if (!str.isEmpty()) {
            stream.write(str.getBytes());
        }
    }

    public static class RawData {
        private final String sourceFile;
        private final DebuggerDebugMethodInfo.RawData[] methods;

        public RawData(String sourceFile, DebuggerDebugMethodInfo.RawData[] methods) {
            this.sourceFile = sourceFile;
            this.methods = methods;
        }
    }
}

