/*
 * Decompiled with CFR 0.152.
 */
package org.robovm.debugger.jdwp.handlers.threadgroup;

import java.util.HashSet;
import org.robovm.debugger.jdwp.protocol.IJdwpRequestHandler;
import org.robovm.debugger.state.VmDebuggerState;
import org.robovm.debugger.state.instances.VmThread;
import org.robovm.debugger.state.instances.VmThreadGroup;
import org.robovm.debugger.utils.bytebuffer.DataBufferReader;
import org.robovm.debugger.utils.bytebuffer.DataBufferWriter;

public class JdwpThreadGroupChildrenHandler
implements IJdwpRequestHandler {
    private final VmDebuggerState state;

    public JdwpThreadGroupChildrenHandler(VmDebuggerState state) {
        this.state = state;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public short handle(DataBufferReader payload, DataBufferWriter output) {
        long threadGroupId = payload.readLong();
        Object object = this.state.centralLock();
        synchronized (object) {
            VmThreadGroup threadGroup;
            try {
                threadGroup = (VmThreadGroup)this.state.referenceRefIdHolder().instanceById(threadGroupId);
            }
            catch (ClassCastException e) {
                return 11;
            }
            if (threadGroup == null) {
                return 11;
            }
            output.writeInt32(0);
            int cnt = 0;
            for (VmThread thread : this.state.threads()) {
                if (thread.threadGroup().refId() != threadGroupId) continue;
                output.writeLong(thread.refId());
                ++cnt;
            }
            if (cnt != 0) {
                output.setPosition(0L);
                output.writeInt32(cnt);
                output.setPosition(output.size());
            }
            HashSet<Long> threadGroups = new HashSet<Long>();
            for (VmThread thread : this.state.threads()) {
                VmThreadGroup parent = thread.threadGroup().parent();
                if (parent == null || parent.refId() != threadGroupId) continue;
                threadGroups.add(thread.threadGroup().refId());
            }
            output.writeInt32(threadGroups.size());
            for (Long childGroupId : threadGroups) {
                output.writeLong(childGroupId);
            }
        }
        return 0;
    }

    @Override
    public byte getCommandSet() {
        return 12;
    }

    @Override
    public byte getCommand() {
        return 3;
    }

    public String toString() {
        return "ThreadGroup(12).Children(3)";
    }
}

