/*
 * Decompiled with CFR 0.152.
 */
package org.robovm.debugger.utils.macho.structs;

import org.robovm.debugger.utils.bytebuffer.DataBufferArrayReader;
import org.robovm.debugger.utils.bytebuffer.DataBufferReader;

public class Section {
    private String sectname;
    private String segname;
    private long addr;
    private long size;
    private long offset;
    private long align;
    private long reloff;
    private long nreloc;
    private long flags;
    private long reserved1;
    private long reserved2;
    private long reserved3;
    private static DataBufferArrayReader.ObjectReader<Section> objectReader32 = new DataBufferArrayReader.ObjectReader<Section>(){

        @Override
        public Section readObject(DataBufferReader reader, Section object) {
            return object == null ? new Section().read32(reader) : object.read32(reader);
        }
    };
    private static DataBufferArrayReader.ObjectReader<Section> objectReader64 = new DataBufferArrayReader.ObjectReader<Section>(){

        @Override
        public Section readObject(DataBufferReader reader, Section object) {
            return object == null ? new Section().read64(reader) : object.read64(reader);
        }
    };

    private Section read32(DataBufferReader reader) {
        this.sectname = reader.readString(16);
        this.segname = reader.readString(16);
        this.addr = reader.readInt32();
        this.size = reader.readInt32();
        this.offset = reader.readInt32();
        this.align = reader.readInt32();
        this.reloff = reader.readInt32();
        this.nreloc = reader.readInt32();
        this.flags = reader.readInt32();
        this.reserved1 = reader.readInt32();
        this.reserved2 = reader.readInt32();
        return this;
    }

    private Section read64(DataBufferReader reader) {
        this.sectname = reader.readString(16);
        this.segname = reader.readString(16);
        this.addr = reader.readLong();
        this.size = reader.readLong();
        this.offset = reader.readUnsignedInt32();
        this.align = reader.readUnsignedInt32();
        this.reloff = reader.readUnsignedInt32();
        this.nreloc = reader.readUnsignedInt32();
        this.flags = reader.readUnsignedInt32();
        this.reserved1 = reader.readUnsignedInt32();
        this.reserved2 = reader.readUnsignedInt32();
        this.reserved3 = reader.readUnsignedInt32();
        return this;
    }

    public String sectname() {
        return this.sectname;
    }

    public String segname() {
        return this.segname;
    }

    public long addr() {
        return this.addr;
    }

    public long size() {
        return this.size;
    }

    public long offset() {
        return this.offset;
    }

    public long align() {
        return this.align;
    }

    public long reloff() {
        return this.reloff;
    }

    public long nreloc() {
        return this.nreloc;
    }

    public long flags() {
        return this.flags;
    }

    public static DataBufferArrayReader.ObjectReader<Section> OBJECT_READER(boolean is64b) {
        return is64b ? objectReader64 : objectReader32;
    }

    public static int ITEM_SIZE(boolean is64b) {
        return is64b ? 80 : 68;
    }
}

