/*
 * Decompiled with CFR 0.152.
 */
package org.robovm.debugger.hooks;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.InetSocketAddress;
import java.net.Socket;
import java.nio.ByteOrder;
import java.nio.file.Files;
import java.util.HashMap;
import java.util.Map;
import java.util.function.IntSupplier;
import org.robovm.debugger.DebuggerException;
import org.robovm.debugger.hooks.HookReqHolder;
import org.robovm.debugger.hooks.IHooksApi;
import org.robovm.debugger.hooks.IHooksConnection;
import org.robovm.debugger.hooks.IHooksEventsHandler;
import org.robovm.debugger.hooks.payloads.HooksCallStackEntry;
import org.robovm.debugger.hooks.payloads.HooksClassLoadedEventPayload;
import org.robovm.debugger.hooks.payloads.HooksCmdResponse;
import org.robovm.debugger.hooks.payloads.HooksEventPayload;
import org.robovm.debugger.hooks.payloads.HooksSuspendThreadPayload;
import org.robovm.debugger.hooks.payloads.HooksThreadEventPayload;
import org.robovm.debugger.hooks.payloads.HooksThreadStoppedEventPayload;
import org.robovm.debugger.utils.DbgLogger;
import org.robovm.debugger.utils.IDebuggerToolbox;
import org.robovm.debugger.utils.bytebuffer.DataBufferReader;
import org.robovm.debugger.utils.bytebuffer.DataBufferReaderWriter;
import org.robovm.debugger.utils.bytebuffer.DataByteBufferWriter;

public class HooksChannel
implements IHooksApi {
    private static final int DEFAULT_TIMEOUT = 5000;
    private final Thread socketThread;
    private final boolean is64bit;
    private IHooksConnection hooksConnection;
    private long reqIdCounter = 100L;
    private final Map<Long, HookReqHolder> requestsInProgress = new HashMap<Long, HookReqHolder>();
    private final DataBufferReaderWriter headerBuffer;
    private final IHooksEventsHandler eventsHandler;

    public HooksChannel(IDebuggerToolbox toolbox, boolean is64bit, IHooksConnection connection, IHooksEventsHandler eventsHandler) {
        this.hooksConnection = connection;
        this.is64bit = is64bit;
        this.eventsHandler = eventsHandler;
        this.socketThread = toolbox.createThread(this::doSocketWork, "HooksChannel socket thread");
        this.headerBuffer = new DataByteBufferWriter();
        this.headerBuffer.setByteOrder(ByteOrder.BIG_ENDIAN);
    }

    public void start() {
        this.socketThread.start();
    }

    public void shutdown() {
        if (this.hooksConnection != null) {
            try {
                this.hooksConnection.disconnect();
                this.hooksConnection = null;
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
    }

    private void doSocketWork() {
        try {
            this.hooksConnection.connect();
            InputStream inputStream = this.hooksConnection.getInputStream();
            OutputStream outputStream = this.hooksConnection.getOutputStream();
            DataByteBufferWriter buffer = new DataByteBufferWriter(this.is64bit);
            buffer.setByteOrder(ByteOrder.BIG_ENDIAN);
            buffer.writeFromStream(inputStream, 8);
            buffer.setPosition(0L);
            long handshake2 = buffer.readLong();
            if (handshake2 != 5940074663853768511L) {
                throw new DebuggerException("Handshake failed!");
            }
            buffer.reset();
            buffer.writeLong(5940074663853760801L);
            buffer.dumpToOutputStream(outputStream);
            buffer.reset();
            buffer.writeFromStream(inputStream, 8);
            buffer.setPosition(0L);
            long robovmBaseSymbol = buffer.readLong();
            this.eventsHandler.onHooksTargetAttached(this, robovmBaseSymbol);
            while (!this.socketThread.isInterrupted()) {
                buffer.reset();
                buffer.writeFromStream(inputStream, 17);
                buffer.setPosition(0L);
                byte cmd = buffer.readByte();
                long reqId = buffer.readLong();
                long payloadSize = buffer.readLong();
                buffer.reset();
                if (payloadSize != 0L) {
                    buffer.writeFromStream(inputStream, (int)payloadSize);
                    buffer.resetReader();
                }
                if (reqId == 0L) {
                    if (!this.isEvent(cmd)) {
                        throw new DebuggerException("Non event response received with reqId == 0");
                    }
                    HooksEventPayload payload = this.createEventPayloadObject(cmd, buffer);
                    this.eventsHandler.onHooksTargetEvent(payload);
                    continue;
                }
                HookReqHolder holder = this.requestsInProgress.remove(reqId);
                if (holder == null) {
                    throw new DebuggerException("Unexpected response id " + reqId + ", cmd = " + cmd);
                }
                HooksCmdResponse response = this.createCmdPayloadObject(cmd, buffer);
                holder.setResponse(response);
                holder.release();
            }
        }
        catch (Throwable e) {
            throw new DebuggerException(e);
        }
    }

    private HooksCmdResponse sendCommand(byte cmd, DataBufferReader payload) {
        if (Thread.currentThread().getId() == this.socketThread.getId()) {
            throw new DebuggerException("Send command should not be invoked from response listening thread due blocking of last");
        }
        long reqId = this.reqIdCounter++;
        this.headerBuffer.reset();
        this.headerBuffer.writeByte(cmd);
        this.headerBuffer.writeLong(reqId);
        this.headerBuffer.writeLong(payload.size());
        this.headerBuffer.resetReader();
        payload.resetReader();
        HookReqHolder holder = new HookReqHolder(cmd);
        this.requestsInProgress.put(reqId, holder);
        try {
            OutputStream outputStream = this.hooksConnection.getOutputStream();
            this.headerBuffer.dumpToOutputStream(outputStream);
            payload.dumpToOutputStream(outputStream);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        try {
            if (!holder.aquire(5000L)) {
                throw new DebuggerException("timeout performing req:" + reqId + "cmd " + cmd);
            }
        }
        catch (InterruptedException e) {
            throw new DebuggerException(e);
        }
        return holder.response;
    }

    @Override
    public byte[] readMemory(long addr, int numBytes) {
        DataByteBufferWriter packet = new DataByteBufferWriter();
        packet.writeLong(addr);
        packet.writeInt32(numBytes);
        HooksCmdResponse resp = this.sendCommand((byte)1, packet);
        return (byte[])resp.result();
    }

    @Override
    public String readCString(long addr) {
        DataByteBufferWriter packet = new DataByteBufferWriter();
        packet.writeLong(addr);
        HooksCmdResponse resp = this.sendCommand((byte)2, packet);
        return (String)resp.result();
    }

    @Override
    public void writeMemory(long addr, byte[] data) {
        DataByteBufferWriter packet = new DataByteBufferWriter();
        packet.writeLong(addr);
        packet.writeInt32(data.length);
        packet.writeBytes(data);
        this.sendCommand((byte)3, packet);
    }

    @Override
    public void writeMemory(long addr, DataBufferReader data) {
        DataByteBufferWriter packet = new DataByteBufferWriter();
        packet.writeLong(addr);
        packet.writeInt32(data.size());
        packet.writeFromReader(data.resetReader());
        this.sendCommand((byte)3, packet);
    }

    @Override
    public void andBits(long addr, byte mask) {
        DataByteBufferWriter packet = new DataByteBufferWriter();
        packet.writeLong(addr);
        packet.writeByte(mask);
        this.sendCommand((byte)4, packet);
    }

    @Override
    public void orBits(long addr, byte mask) {
        DataByteBufferWriter packet = new DataByteBufferWriter();
        packet.writeLong(addr);
        packet.writeByte(mask);
        this.sendCommand((byte)5, packet);
    }

    @Override
    public long allocate(int numBytes) {
        DataByteBufferWriter packet = new DataByteBufferWriter();
        packet.writeInt32(numBytes);
        HooksCmdResponse resp = this.sendCommand((byte)6, packet);
        return (Long)resp.result();
    }

    @Override
    public void free(long addr) {
        DataByteBufferWriter packet = new DataByteBufferWriter();
        packet.writeLong(addr);
        this.sendCommand((byte)7, packet);
    }

    @Override
    public void classFilter(boolean isSet, String className) {
        DataByteBufferWriter packet = new DataByteBufferWriter();
        packet.writeByte((byte)(isSet ? -1 : 0));
        packet.writeStringWithLen(className);
        this.sendCommand((byte)70, packet);
    }

    @Override
    public HooksCmdResponse threadSuspend(long thread) {
        DataByteBufferWriter packet = new DataByteBufferWriter();
        packet.writeLong(thread);
        return this.sendCommand((byte)50, packet);
    }

    @Override
    public void threadResume(long thread) {
        DataByteBufferWriter packet = new DataByteBufferWriter();
        packet.writeLong(thread);
        this.sendCommand((byte)51, packet);
    }

    @Override
    public void threadStep(long thread, long pcLow, long pcHigh, long pcLow2, long pcHigh2) {
        DataByteBufferWriter packet = new DataByteBufferWriter();
        packet.writeLong(thread);
        packet.writeLong(pcLow);
        packet.writeLong(pcHigh);
        packet.writeLong(pcLow2);
        packet.writeLong(pcHigh2);
        this.sendCommand((byte)52, packet);
    }

    @Override
    public HooksCmdResponse threadInvoke(long thread, long classOrObjectPtr, String methodName, String descriptor, boolean isClassMethod, byte returnType, DataBufferReader arguments) {
        long argumentsPtr = 0L;
        if (arguments != null) {
            argumentsPtr = this.allocate(arguments.size());
            this.writeMemory(argumentsPtr, arguments);
        }
        DataByteBufferWriter packet = new DataByteBufferWriter();
        packet.writeLong(thread);
        packet.writeLong(classOrObjectPtr);
        packet.writeStringWithLen(methodName);
        packet.writeStringWithLen(descriptor);
        packet.writeBoolean(isClassMethod);
        packet.writeByte(returnType);
        packet.writeLong(argumentsPtr);
        HooksCmdResponse resp = this.sendCommand((byte)53, packet);
        if (argumentsPtr != 0L) {
            this.free(argumentsPtr);
        }
        return resp;
    }

    @Override
    public HooksCmdResponse newInstance(long thread, long classOrObjectPtr, String methodName, String descriptor, DataBufferReader arguments) {
        long argumentsPtr = 0L;
        if (arguments != null) {
            argumentsPtr = this.allocate(arguments.size());
            this.writeMemory(argumentsPtr, arguments);
        }
        DataByteBufferWriter packet = new DataByteBufferWriter();
        packet.writeLong(thread);
        packet.writeLong(classOrObjectPtr);
        packet.writeStringWithLen(methodName);
        packet.writeStringWithLen(descriptor);
        packet.writeLong(argumentsPtr);
        HooksCmdResponse resp = this.sendCommand((byte)56, packet);
        if (argumentsPtr != 0L) {
            this.free(argumentsPtr);
        }
        return resp;
    }

    @Override
    public HooksCmdResponse newString(long thread, String s) {
        DataByteBufferWriter packet = new DataByteBufferWriter();
        packet.writeLong(thread);
        byte[] bytes = s.getBytes();
        packet.writeInt32(bytes.length);
        packet.writeBytes(bytes);
        return this.sendCommand((byte)54, packet);
    }

    @Override
    public HooksCmdResponse newArray(long thread, int arrayLength, String elementName) {
        DataByteBufferWriter packet = new DataByteBufferWriter();
        packet.writeLong(thread);
        packet.writeInt32(arrayLength);
        byte[] bytes = elementName.getBytes();
        packet.writeInt32(bytes.length);
        packet.writeBytes(bytes);
        return this.sendCommand((byte)55, packet);
    }

    private HooksCmdResponse createCmdPayloadObject(byte cmd, DataBufferReader reader) {
        HooksCmdResponse res = null;
        switch (cmd) {
            case 1: {
                res = new HooksCmdResponse(reader.readBytes());
                break;
            }
            case 2: {
                res = new HooksCmdResponse(reader.readString());
                break;
            }
            case 6: {
                res = new HooksCmdResponse(reader.readLong());
                break;
            }
            case 50: {
                int threadStatus = reader.readInt32();
                int suspendStatus = reader.readInt32();
                HooksCallStackEntry[] callStack = this.readCallStack(reader);
                res = new HooksCmdResponse(new HooksSuspendThreadPayload(callStack, threadStatus, suspendStatus));
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 7: 
            case 51: 
            case 52: 
            case 70: {
                break;
            }
            case 53: 
            case 54: 
            case 55: 
            case 56: {
                long resultPtr = reader.readLong();
                long throwable = reader.readLong();
                res = new HooksCmdResponse(resultPtr, throwable);
                break;
            }
            default: {
                throw new DebuggerException("Unrecognized Hooks command " + cmd);
            }
        }
        return res;
    }

    private HooksEventPayload createEventPayloadObject(byte event, DataBufferReader reader) {
        HooksEventPayload res;
        switch (event) {
            case 100: 
            case 101: 
            case 104: {
                long threadObj = reader.readLong();
                long thread = reader.readLong();
                res = new HooksThreadEventPayload(event, threadObj, thread);
                break;
            }
            case 102: {
                long threadObj = reader.readLong();
                long thread = reader.readLong();
                long throwable = reader.readLong();
                res = new HooksThreadEventPayload(event, threadObj, thread, throwable);
                break;
            }
            case 103: 
            case 105: 
            case 106: {
                long threadObj = reader.readLong();
                long thread = reader.readLong();
                int threadStatus = reader.readInt32();
                HooksCallStackEntry[] callStack = this.readCallStack(reader);
                res = new HooksThreadStoppedEventPayload(event, threadObj, thread, threadStatus, callStack);
                break;
            }
            case 108: {
                long threadObj = reader.readLong();
                long thread = reader.readLong();
                int threadStatus = reader.readInt32();
                long throwable = reader.readLong();
                boolean isCaught = reader.readByte() != 0;
                HooksCallStackEntry[] callStack = this.readCallStack(reader);
                res = new HooksThreadStoppedEventPayload(event, threadObj, thread, throwable, isCaught, threadStatus, callStack);
                break;
            }
            case 107: {
                long threadObj = reader.readLong();
                long thread = reader.readLong();
                long clazz = reader.readLong();
                long classInfo = reader.readLong();
                HooksCallStackEntry[] callStack = null;
                if (reader.hasRemaining()) {
                    callStack = this.readCallStack(reader);
                }
                res = new HooksClassLoadedEventPayload(event, threadObj, thread, clazz, classInfo, callStack);
                break;
            }
            default: {
                throw new DebuggerException("Unrecognized Hooks event " + event);
            }
        }
        return res;
    }

    private HooksCallStackEntry[] readCallStack(DataBufferReader reader) {
        HooksCallStackEntry[] res;
        if (reader.hasRemaining()) {
            int count = reader.readInt32();
            res = new HooksCallStackEntry[count];
            for (int idx = 0; idx < count; ++idx) {
                long impl = reader.readLong();
                int lineNumber = reader.readInt32();
                long fp = reader.readLong();
                long pc = reader.readLong();
                int clazzNameLen = reader.readInt32();
                String clazzName = reader.readString(clazzNameLen);
                res[idx] = new HooksCallStackEntry(clazzName, impl, lineNumber, fp, pc);
            }
        } else {
            res = new HooksCallStackEntry[]{};
        }
        return res;
    }

    private boolean isEvent(byte cmd) {
        switch (cmd) {
            case 100: 
            case 101: 
            case 102: 
            case 103: 
            case 104: 
            case 105: 
            case 106: 
            case 107: 
            case 108: {
                return true;
            }
        }
        return false;
    }

    public static void main(String[] argv) {
        int port;
        if ("-port".equals(argv[0])) {
            port = Integer.parseInt(argv[1]);
        } else if ("-file".equals(argv[0])) {
            try {
                File file = new File(argv[1]);
                while (!file.exists() || file.length() == 0L) {
                    Thread.sleep(200L);
                }
                port = Integer.parseInt(new String(Files.readAllBytes(file.toPath())));
            }
            catch (IOException | InterruptedException e) {
                throw new DebuggerException("File IO error", e);
            }
        } else {
            throw new DebuggerException("Unknown arg !");
        }
        IDebuggerToolbox toolbox = Thread::new;
        HooksChannel hooksChannel = new HooksChannel(toolbox, true, new SocketHooksConnection(() -> port), new IHooksEventsHandler(){

            @Override
            public void onHooksTargetAttached(IHooksApi api, long robovmBaseSymbol) {
            }

            @Override
            public void onHooksTargetEvent(HooksEventPayload eventPayload) {
            }
        });
        DbgLogger.setup(null, true);
        hooksChannel.start();
    }

    public static class SocketHooksConnection
    implements IHooksConnection {
        private final IntSupplier hooksPortSupplier;
        private Socket socket;

        public SocketHooksConnection(IntSupplier hooksPortSupplier) {
            this.hooksPortSupplier = hooksPortSupplier;
        }

        @Override
        public void connect() throws IOException {
            int port = this.hooksPortSupplier.getAsInt();
            this.socket = new Socket();
            this.socket.connect(new InetSocketAddress("127.0.0.1", port), 1000);
            this.socket.setTcpNoDelay(true);
        }

        @Override
        public void disconnect() throws IOException {
            if (this.socket != null && this.socket.isClosed()) {
                this.socket.close();
            }
        }

        @Override
        public InputStream getInputStream() throws IOException {
            return this.socket.getInputStream();
        }

        @Override
        public OutputStream getOutputStream() throws IOException {
            return this.socket.getOutputStream();
        }
    }
}

