/*
 * Decompiled with CFR 0.152.
 */
package org.robovm.debugger.jdwp.handlers.arraytype;

import org.robovm.debugger.DebuggerException;
import org.robovm.debugger.jdwp.handlers.array.IJdwpArrayDelegate;
import org.robovm.debugger.jdwp.protocol.IJdwpRequestHandler;
import org.robovm.debugger.utils.bytebuffer.DataBufferReader;
import org.robovm.debugger.utils.bytebuffer.DataBufferWriter;

public class JdwpArrayTypeNewInstanceHandler
implements IJdwpRequestHandler {
    private final IJdwpArrayDelegate delegate;

    public JdwpArrayTypeNewInstanceHandler(IJdwpArrayDelegate delegate) {
        this.delegate = delegate;
    }

    @Override
    public short handle(DataBufferReader payload, DataBufferWriter output) {
        long arrayTypeId = payload.readLong();
        int length = payload.readInt32();
        try {
            long instanceId = this.delegate.jdwpArrayCreateInstance(arrayTypeId, length);
            output.writeByte((byte)91);
            output.writeLong(instanceId);
        }
        catch (DebuggerException e) {
            if (e.getCode() < 0) {
                throw e;
            }
            return (short)e.getCode();
        }
        return 0;
    }

    @Override
    public byte getCommandSet() {
        return 4;
    }

    @Override
    public byte getCommand() {
        return 1;
    }

    public String toString() {
        return "ArrayType(4).NewInstance(1)";
    }
}

