/*
 * Decompiled with CFR 0.152.
 */
package org.robovm.debugger.jdwp.handlers.eventrequest.events.predicates;

import org.robovm.debugger.jdwp.handlers.eventrequest.events.EventData;
import org.robovm.debugger.jdwp.handlers.eventrequest.events.predicates.EventPredicate;

public class EventClassNameMatchPredicate
extends EventPredicate {
    private final String pattern;
    private final boolean negative;

    public EventClassNameMatchPredicate(byte eventKind, String pattern, boolean negative) {
        super(eventKind);
        this.pattern = pattern;
        this.negative = negative;
    }

    public String pattern() {
        return this.pattern;
    }

    public boolean isNegative() {
        return this.negative;
    }

    public boolean isExact() {
        return !this.pattern.startsWith("*") && !this.pattern.endsWith("*");
    }

    @Override
    public boolean test(EventData eventData) {
        boolean result = EventClassNameMatchPredicate.matchPattern(this.pattern, eventData.getClassName());
        return this.negative ? !result : result;
    }

    public static boolean matchPattern(String pattern, String str) {
        if (pattern.startsWith("*")) {
            return str.regionMatches(str.length() - (pattern.length() - 1), pattern, 1, pattern.length() - 1);
        }
        if (pattern.endsWith("*")) {
            return str.regionMatches(0, pattern, 0, pattern.length() - 1);
        }
        return pattern.equals(str);
    }

    public String toString() {
        return "className" + (this.negative ? "!=" : "=") + this.pattern;
    }
}

