/*
 * Decompiled with CFR 0.152.
 */
package org.robovm.debugger.jdwp.handlers.referencetype;

import org.robovm.debugger.jdwp.protocol.IJdwpRequestHandler;
import org.robovm.debugger.state.VmDebuggerState;
import org.robovm.debugger.state.classdata.ClassInfo;
import org.robovm.debugger.state.classdata.MethodInfo;
import org.robovm.debugger.utils.bytebuffer.DataBufferReader;
import org.robovm.debugger.utils.bytebuffer.DataBufferWriter;

public class JdwpRefTypeMethodsHandler
implements IJdwpRequestHandler {
    private final VmDebuggerState state;

    public JdwpRefTypeMethodsHandler(VmDebuggerState state) {
        this.state = state;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public short handle(DataBufferReader payload, DataBufferWriter output) {
        long referenceTypeID = payload.readLong();
        Object object = this.state.centralLock();
        synchronized (object) {
            ClassInfo classInfo = this.state.classInfoLoader().classInfoByRefId(referenceTypeID);
            if (classInfo == null) {
                return 20;
            }
            MethodInfo[] fields2 = this.state.classInfoLoader().classMethods(classInfo);
            output.writeInt32(fields2.length);
            for (MethodInfo methodInfo : fields2) {
                output.writeLong(methodInfo.refId());
                output.writeStringWithLen(methodInfo.name());
                output.writeStringWithLen(methodInfo.signature());
                String signatureWithGeneric = this.getGenericSignature();
                if (signatureWithGeneric != null) {
                    output.writeStringWithLen(signatureWithGeneric);
                }
                output.writeInt32(methodInfo.modifiers());
            }
        }
        return 0;
    }

    protected String getGenericSignature() {
        return null;
    }

    @Override
    public byte getCommandSet() {
        return 2;
    }

    @Override
    public byte getCommand() {
        return 5;
    }

    public String toString() {
        return "ReferenceType(2).Methods(5)";
    }
}

