/*
 * Decompiled with CFR 0.152.
 */
package org.robovm.debugger.jdwp.handlers.thread;

import org.robovm.debugger.jdwp.protocol.IJdwpRequestHandler;
import org.robovm.debugger.state.VmDebuggerState;
import org.robovm.debugger.state.instances.VmThread;
import org.robovm.debugger.utils.bytebuffer.DataBufferReader;
import org.robovm.debugger.utils.bytebuffer.DataBufferWriter;

public class JdwpThreadGetNameHandler
implements IJdwpRequestHandler {
    private final VmDebuggerState state;

    public JdwpThreadGetNameHandler(VmDebuggerState state) {
        this.state = state;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public short handle(DataBufferReader payload, DataBufferWriter output) {
        long threadId = payload.readLong();
        Object object = this.state.centralLock();
        synchronized (object) {
            VmThread thread;
            try {
                thread = (VmThread)this.state.referenceRefIdHolder().instanceById(threadId);
            }
            catch (ClassCastException e) {
                return 10;
            }
            if (thread == null) {
                return 10;
            }
            output.writeStringWithLen(thread.name());
        }
        return 0;
    }

    @Override
    public byte getCommandSet() {
        return 11;
    }

    @Override
    public byte getCommand() {
        return 1;
    }

    public String toString() {
        return "ThreadReference(11).Name(1)";
    }
}

