/*
 * Decompiled with CFR 0.152.
 */
package org.robovm.debugger.state.classdata;

import java.io.File;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.robovm.debugger.DebuggerException;
import org.robovm.debugger.runtime.ValueManipulator;
import org.robovm.debugger.state.classdata.ClassInfo;
import org.robovm.debugger.state.classdata.ClassInfoImpl;
import org.robovm.debugger.state.classdata.ClassInfoPrimitiveImpl;
import org.robovm.debugger.state.classdata.FieldInfo;
import org.robovm.debugger.state.classdata.MethodInfo;
import org.robovm.debugger.state.refid.RefIdHolder;
import org.robovm.debugger.utils.DataUtils;
import org.robovm.debugger.utils.bytebuffer.DataBufferReader;
import org.robovm.debugger.utils.macho.MachOException;
import org.robovm.debugger.utils.macho.MachOLoader;

public class ClassInfoLoader {
    final MachOLoader appFileLoader;
    final DataBufferReader reader;
    private final Map<String, ClassInfo> signatureToDataInfo = new HashMap<String, ClassInfo>();
    private final Map<Long, ClassInfo> classInfoAddrToClassInfo = new HashMap<Long, ClassInfo>();
    private final List<ClassInfo> dataInfos;
    private final Map<Long, ClassInfo> classObjAddrToDataInfo = new HashMap<Long, ClassInfo>();
    final RefIdHolder<ClassInfo> classRefIdHolder;
    final RefIdHolder<MethodInfo> methodsRefIdHolder;
    final RefIdHolder<FieldInfo> fieldRefIdHolder;
    private Set<String> allClassNames;
    private ClassInfo[] constArraysInterfaces;

    public ClassInfoLoader(RefIdHolder<ClassInfo> classRefIdHolder, RefIdHolder<MethodInfo> methodsRefIdHolder, RefIdHolder<FieldInfo> fieldRefIdHolder, MachOLoader appFileLoader, DataBufferReader reader) {
        this.classRefIdHolder = classRefIdHolder;
        this.methodsRefIdHolder = methodsRefIdHolder;
        this.fieldRefIdHolder = fieldRefIdHolder;
        this.reader = reader;
        this.appFileLoader = appFileLoader;
        long bcBootClassesHash = appFileLoader.resolveSymbol("_bcBootClassesHash");
        long bcClassesHash = appFileLoader.resolveSymbol("_bcClassesHash");
        this.parseHash(this.reader.setPosition(bcBootClassesHash).readPointer());
        this.parseHash(this.reader.setPosition(bcClassesHash).readPointer());
        this.dataInfos = Collections.unmodifiableList(new ArrayList<ClassInfo>(this.signatureToDataInfo.values()));
    }

    private void parseHash(long hash) {
        this.reader.setPosition(hash);
        long pointerSize = this.reader.pointerSize();
        int classInfoCount = this.reader.readInt32();
        int hashTableSize = this.reader.readInt32();
        long base = hash + 4L + 4L + (long)(hashTableSize << 2) + 4L;
        base = DataUtils.align(base, pointerSize);
        for (int i = 0; i < classInfoCount; ++i) {
            this.reader.setPosition(base);
            long classInfoPtr = this.reader.readPointer();
            this.reader.setPosition(classInfoPtr);
            ClassInfoImpl classInfo = new ClassInfoImpl();
            classInfo.readClassInfoHeader(this.reader);
            this.classRefIdHolder.addObject(classInfo);
            this.signatureToDataInfo.put(classInfo.signature(), classInfo);
            this.classInfoAddrToClassInfo.put(classInfoPtr, classInfo);
            base += pointerSize;
        }
    }

    public ClassInfo classInfoBySignature(String signature) {
        return this.signatureToDataInfo.get(signature);
    }

    public ClassInfo classInfoByRefId(long refId) {
        return this.classRefIdHolder.objectById(refId);
    }

    public ClassInfo classByClazzAddr(long classPointer) {
        return this.classObjAddrToDataInfo.get(classPointer);
    }

    public List<ClassInfo> classes() {
        return this.dataInfos;
    }

    public ClassInfo onClassLoaded(long classInfoPtr, long clazzPtr) {
        ClassInfo classInfo = this.classInfoAddrToClassInfo.get(classInfoPtr);
        if (classInfo == null) {
            throw new DebuggerException("TODO: unknown class info ptr!");
        }
        classInfo.setClazzPtr(clazzPtr);
        this.classObjAddrToDataInfo.put(clazzPtr, classInfo);
        return classInfo;
    }

    public void registerRuntimeClassInfo(ClassInfo classInfo, long clazzPtr) {
        this.classRefIdHolder.addObject(classInfo);
        this.signatureToDataInfo.put(classInfo.signature(), classInfo);
        this.classObjAddrToDataInfo.put(clazzPtr, classInfo);
    }

    public ClassInfo buildPrimitiveClassInfo(char signature, long clazzPtr) {
        String signatureStr = String.valueOf(signature);
        switch (signature) {
            case 'Z': {
                return new ClassInfoPrimitiveImpl(signatureStr, clazzPtr, 1, ValueManipulator.Boolean);
            }
            case 'B': {
                return new ClassInfoPrimitiveImpl(signatureStr, clazzPtr, 1, ValueManipulator.Byte);
            }
            case 'C': {
                return new ClassInfoPrimitiveImpl(signatureStr, clazzPtr, 2, ValueManipulator.Character);
            }
            case 'S': {
                return new ClassInfoPrimitiveImpl(signatureStr, clazzPtr, 2, ValueManipulator.Short);
            }
            case 'I': {
                return new ClassInfoPrimitiveImpl(signatureStr, clazzPtr, 4, ValueManipulator.Integer);
            }
            case 'J': {
                return new ClassInfoPrimitiveImpl(signatureStr, clazzPtr, 8, ValueManipulator.Long);
            }
            case 'F': {
                return new ClassInfoPrimitiveImpl(signatureStr, clazzPtr, 4, ValueManipulator.Float);
            }
            case 'D': {
                return new ClassInfoPrimitiveImpl(signatureStr, clazzPtr, 8, ValueManipulator.Double);
            }
            case 'V': {
                return new ClassInfoPrimitiveImpl(signatureStr, clazzPtr, 0, ValueManipulator.Void);
            }
        }
        return null;
    }

    public FieldInfo[] classFields(ClassInfo classInfo) {
        return classInfo.fields(this);
    }

    public MethodInfo[] classMethods(ClassInfo classInfo) {
        return classInfo.methods(this);
    }

    public static boolean isArraySignature(String signature) {
        return signature.length() > 1 && signature.startsWith("[");
    }

    public static boolean isClassSignature(String signature) {
        return signature.length() > 2 && signature.startsWith("L") && signature.endsWith(";");
    }

    public static boolean isPrimitiveSignature(String signature) {
        return signature.length() == 1 && "ZBCSIJFD".contains(signature);
    }

    public static void main(String[] argv) {
        try {
            MachOLoader loader = new MachOLoader(new File(argv[0]), MachOLoader.cpuTypeFromString(argv[1]));
            ClassInfoLoader classInfoLoader = new ClassInfoLoader(new RefIdHolder<ClassInfo>(RefIdHolder.RefIdType.CLASS_TYPE), new RefIdHolder<MethodInfo>(RefIdHolder.RefIdType.METHOD_TYPE), new RefIdHolder<FieldInfo>(RefIdHolder.RefIdType.FIELD_TYPE), loader, loader.memoryReader());
            for (ClassInfo info : classInfoLoader.dataInfos) {
                ((ClassInfoImpl)info).loadData(classInfoLoader);
            }
            System.out.println("Loaded " + classInfoLoader.signatureToDataInfo.size() + " classes");
        }
        catch (MachOException e) {
            e.printStackTrace();
        }
    }

    public Set<String> allClassNames() {
        if (this.allClassNames == null) {
            this.allClassNames = new HashSet<String>();
            for (ClassInfo ci : this.classes()) {
                if (!ci.isClass()) continue;
                ClassInfoImpl classInfo = (ClassInfoImpl)ci;
                this.allClassNames.add(classInfo.className());
            }
        }
        return this.allClassNames;
    }

    public ClassInfo[] constArraysInterfaces() {
        if (this.constArraysInterfaces == null) {
            this.constArraysInterfaces = new ClassInfo[2];
            this.constArraysInterfaces[0] = this.classInfoBySignature("Ljava/lang/Cloneable;");
            this.constArraysInterfaces[1] = this.classInfoBySignature("Ljava/io/Serializable;");
        }
        return this.constArraysInterfaces;
    }
}

