/*
 * Decompiled with CFR 0.152.
 */
package org.robovm.debugger.state.classdata;

import java.util.regex.Pattern;
import org.robovm.debugger.DebuggerException;
import org.robovm.debugger.delegates.AllDelegates;
import org.robovm.debugger.state.classdata.ClassInfo;
import org.robovm.debugger.state.classdata.ClassInfoArrayImpl;
import org.robovm.debugger.state.classdata.ClassInfoLoader;

public class RuntimeClassInfoLoader {
    private final AllDelegates delegates;

    public RuntimeClassInfoLoader(AllDelegates delegates) {
        this.delegates = delegates;
    }

    public ClassInfo resolveRuntimeDataTypeInfo(long clazzPointer) {
        ClassInfo dataTypeInfo = this.delegates.state().classInfoLoader().classByClazzAddr(clazzPointer);
        if (dataTypeInfo == null) {
            String signature = this.readClazzSignature(clazzPointer);
            dataTypeInfo = this.resolveRuntimeDataTypeInfo(signature, clazzPointer);
        }
        return dataTypeInfo;
    }

    public ClassInfo resolveObjectRuntimeDataTypeInfo(long objectPtr) {
        this.delegates.runtime().deviceMemoryReader().setPosition(objectPtr);
        long clazzPointer = this.delegates.runtime().deviceMemoryReader().readPointer();
        return this.resolveRuntimeDataTypeInfo(clazzPointer);
    }

    public ClassInfo resolveRuntimeDataTypeInfo(String signature, long clazzPtr) {
        ClassInfo info;
        char firstChar = signature.charAt(0);
        if (signature.length() == 1) {
            info = this.delegates.state().classInfoLoader().buildPrimitiveClassInfo(firstChar, clazzPtr);
        } else if (firstChar == '[') {
            String componentTypeSignature = signature.substring(1);
            ClassInfo componentType = this.delegates.state().classInfoLoader().classInfoBySignature(componentTypeSignature);
            if (componentType == null) {
                long componentClazzPtr = this.readClazzComponentType(clazzPtr);
                componentType = this.resolveRuntimeDataTypeInfo(componentTypeSignature, componentClazzPtr);
            }
            info = new ClassInfoArrayImpl(signature, componentType);
        } else {
            info = this.delegates.state().classInfoLoader().classInfoBySignature("L" + signature + ";");
            if (info != null) {
                return info;
            }
            if (Pattern.matches(".*/\\$Proxy\\d+$", signature)) {
                info = this.delegates.state().classInfoLoader().classInfoBySignature("Ljava/lang/Object;");
            }
        }
        if (info == null) {
            throw new DebuggerException("Unable to resolve runtime class for " + signature);
        }
        this.delegates.state().classInfoLoader().registerRuntimeClassInfo(info, clazzPtr);
        return info;
    }

    public ClassInfo getPrimitiveClassInfo(char signature) {
        ClassInfo info = this.loader().classInfoBySignature(String.valueOf(signature));
        if (info == null) {
            info = this.buildPrimitiveClassInfo(signature);
        }
        return info;
    }

    public ClassInfo buildPrimitiveClassInfo(String signature) {
        if (signature.length() != 1) {
            throw new DebuggerException("Invalid signature for primitive " + signature);
        }
        return this.buildPrimitiveClassInfo(signature.charAt(0));
    }

    public ClassInfo buildPrimitiveClassInfo(char signature) {
        long clazzPrt = this.delegates.state().appFileLoader().resolveSymbol("prim_" + signature);
        if (clazzPrt < 0L) {
            throw new DebuggerException("Failed to resolve primitive clazz symbol prim_" + signature);
        }
        this.delegates.runtime().deviceMemoryReader().setPosition(this.delegates.runtime().toRuntimeAddr(clazzPrt));
        clazzPrt = this.delegates.runtime().deviceMemoryReader().readPointer();
        return this.delegates.state().classInfoLoader().buildPrimitiveClassInfo(signature, clazzPrt);
    }

    public long readClazzComponentType(long clazzPointer) {
        long pointerSize = this.delegates.runtime().deviceMemoryReader().pointerSize();
        this.delegates.runtime().deviceMemoryReader().setPosition(clazzPointer + pointerSize + pointerSize + pointerSize + pointerSize + pointerSize + pointerSize + pointerSize + pointerSize + pointerSize + pointerSize);
        return this.delegates.runtime().deviceMemoryReader().readPointer();
    }

    public String readClazzSignature(long clazzPointer) {
        long pointerSize = this.delegates.runtime().deviceMemoryReader().pointerSize();
        this.delegates.runtime().deviceMemoryReader().setPosition(clazzPointer + pointerSize + pointerSize + pointerSize + pointerSize + pointerSize + pointerSize + pointerSize);
        long ptr = this.delegates.runtime().deviceMemoryReader().readPointer();
        return this.delegates.runtime().deviceMemoryReader().readStringZAtPtr(ptr);
    }

    public ClassInfoLoader loader() {
        return this.delegates.state().classInfoLoader();
    }
}

