/*
 * Decompiled with CFR 0.152.
 */
package org.robovm.debugger.state.refid;

import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.atomic.AtomicLong;

public class RefIdHolder<T extends IRefIdObject> {
    private final AtomicLong generator;
    protected final Map<Long, T> idToObject;
    private final long refIdStep = RefIdType.values().length;

    public RefIdHolder(RefIdType type) {
        this.generator = new AtomicLong(type.ordinal());
        this.idToObject = new HashMap<Long, T>();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public T addObject(T obj) {
        long refId = this.generator.addAndGet(this.refIdStep);
        obj.setRefId(refId);
        Map<Long, T> map = this.idToObject;
        synchronized (map) {
            this.idToObject.put(refId, obj);
        }
        return obj;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public T removeObject(T obj) {
        Map<Long, T> map = this.idToObject;
        synchronized (map) {
            return (T)((IRefIdObject)this.idToObject.remove(obj.refId()));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public T objectById(long refId) {
        Map<Long, T> map = this.idToObject;
        synchronized (map) {
            return (T)((IRefIdObject)this.idToObject.get(refId));
        }
    }

    public RefIdType typeOf(T obj) {
        long refIdTypeIdx = obj.refId() % this.refIdStep;
        return RefIdType.values()[(int)refIdTypeIdx];
    }

    public static enum RefIdType {
        CLASS_TYPE,
        FIELD_TYPE,
        METHOD_TYPE,
        REFERENCE_TYPE,
        FRAME_TYPE;

    }

    public static interface IRefIdObject {
        public void setRefId(long var1);

        public long refId();
    }
}

