/*
 * Decompiled with CFR 0.152.
 */
package org.robovm.debugger.utils.bytebuffer;

import java.nio.ByteOrder;
import org.robovm.debugger.utils.bytebuffer.DataBuffer;
import org.robovm.debugger.utils.bytebuffer.DataBufferReader;

public abstract class CompositeDataBuffer<T extends DataBufferReader>
implements DataBufferReader {
    protected final T[] regions;
    protected T activeRegion;

    public CompositeDataBuffer(T[] regions) {
        this.regions = regions;
    }

    @Override
    public DataBufferReader setPosition(long addr) {
        this.activeRegion = this.findRegion(addr);
        if (this.activeRegion == null) {
            throw new IllegalArgumentException("there is no region for addr @" + Long.toHexString(addr));
        }
        this.activeRegion.setPosition(addr);
        return this;
    }

    private T findRegion(long addr) {
        if (this.activeRegion != null && addr >= this.activeRegion.bottomLimit() && addr < this.activeRegion.limit()) {
            return this.activeRegion;
        }
        int left = 0;
        int right = this.regions.length - 1;
        while (right >= left) {
            int middle = (left + right) / 2;
            T r = this.regions[middle];
            if (addr < r.bottomLimit()) {
                right = middle - 1;
                continue;
            }
            if (addr >= r.limit()) {
                left = middle + 1;
                continue;
            }
            return r;
        }
        return null;
    }

    @Override
    public long position() {
        if (this.activeRegion == null) {
            throw new IllegalStateException("Address has not been set!");
        }
        return this.activeRegion.position();
    }

    @Override
    public long bottomLimit() {
        return this.regions[0].bottomLimit();
    }

    @Override
    public long limit() {
        return this.regions[this.regions.length - 1].limit();
    }

    @Override
    public DataBuffer reset() {
        this.activeRegion = this.regions[0];
        this.activeRegion.reset();
        return this;
    }

    @Override
    public DataBuffer setByteOrder(ByteOrder order) {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean is64bit() {
        return this.regions[0].is64bit();
    }

    @Override
    public int pointerSize() {
        return this.is64bit() ? 8 : 4;
    }

    @Override
    public int remaining() {
        return this.activeRegion.remaining();
    }

    @Override
    public long readPointer(boolean aligned) {
        return this.activeRegion.readPointer(aligned);
    }

    @Override
    public byte readByte() {
        return this.activeRegion.readByte();
    }

    @Override
    public short readInt16() {
        return this.activeRegion.readInt16();
    }

    @Override
    public int readInt32() {
        return this.activeRegion.readInt32();
    }

    @Override
    public long readLong() {
        return this.activeRegion.readLong();
    }

    @Override
    public float readFloat() {
        return this.activeRegion.readFloat();
    }

    @Override
    public double readDouble() {
        return this.activeRegion.readDouble();
    }

    @Override
    public void readBytes(byte[] dst, int offset, int length) {
        this.activeRegion.readBytes(dst, offset, length);
    }
}

