/*
 * Decompiled with CFR 0.152.
 */
package org.robovm.debugger.utils.bytebuffer;

import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import org.robovm.debugger.utils.bytebuffer.DataBufferReader;

public class DataByteBufferReader
implements DataBufferReader {
    protected ByteBuffer byteBuffer;
    protected final long bottomLimit;
    protected final boolean is64bit;

    public DataByteBufferReader(ByteBuffer byteBuffer, long bottomLimit, boolean is64bit) {
        this.byteBuffer = byteBuffer;
        this.bottomLimit = bottomLimit;
        this.is64bit = is64bit;
    }

    public DataByteBufferReader(ByteBuffer byteBuffer, boolean is64bit) {
        this(byteBuffer, 0L, is64bit);
    }

    public DataByteBufferReader(byte[] bytes, boolean is64bit) {
        this(ByteBuffer.wrap(bytes), is64bit);
    }

    public DataByteBufferReader(ByteBuffer bb) {
        this(bb, false);
    }

    public DataByteBufferReader(byte[] bytes) {
        this(ByteBuffer.wrap(bytes), false);
    }

    @Override
    public boolean is64bit() {
        return this.is64bit;
    }

    @Override
    public long position() {
        return this.bottomLimit + (long)this.byteBuffer.position();
    }

    @Override
    public long bottomLimit() {
        return this.bottomLimit;
    }

    @Override
    public long limit() {
        return this.bottomLimit + (long)this.byteBuffer.limit();
    }

    @Override
    public DataByteBufferReader setPosition(long position) {
        this.byteBuffer.position((int)(position - this.bottomLimit));
        return this;
    }

    @Override
    public DataByteBufferReader reset() {
        this.byteBuffer.reset();
        return this;
    }

    @Override
    public boolean hasArray() {
        return this.byteBuffer.hasArray();
    }

    @Override
    public byte[] array() {
        return this.byteBuffer.array();
    }

    @Override
    public int arrayOffset() {
        return this.byteBuffer.arrayOffset();
    }

    @Override
    public int remaining() {
        return this.byteBuffer.remaining();
    }

    @Override
    public byte readByte() {
        return this.byteBuffer.get();
    }

    @Override
    public short readInt16() {
        return this.byteBuffer.getShort();
    }

    @Override
    public int readInt32() {
        return this.byteBuffer.getInt();
    }

    @Override
    public long readLong() {
        return this.byteBuffer.getLong();
    }

    @Override
    public float readFloat() {
        return this.byteBuffer.getFloat();
    }

    @Override
    public double readDouble() {
        return this.byteBuffer.getDouble();
    }

    @Override
    public void readBytes(byte[] dst, int offset, int length) {
        this.byteBuffer.get(dst, offset, length);
    }

    @Override
    public DataByteBufferReader sliceAt(long pos, int size, long newBottomLimit, boolean as64bit) {
        long savedPosition = this.position();
        this.setPosition(pos);
        this.expects(size);
        ByteBuffer sliced = this.byteBuffer.slice();
        sliced.limit(size);
        sliced.order(this.byteBuffer.order());
        this.setPosition(savedPosition);
        return new DataByteBufferReader(sliced, newBottomLimit, as64bit);
    }

    @Override
    public DataByteBufferReader setByteOrder(ByteOrder order) {
        this.byteBuffer.order(order);
        return this;
    }

    public String toString() {
        return "DataByteBufferReader{" + Long.toHexString(this.bottomLimit) + " ... " + Long.toHexString(this.limit() - 1L) + '}';
    }
}

