/*
 * Decompiled with CFR 0.152.
 */
package org.robovm.debugger.utils.macho.structs;

import java.util.ArrayList;
import java.util.Map;
import org.robovm.debugger.utils.bytebuffer.DataBufferReader;
import org.robovm.debugger.utils.macho.tools.Bits64;
import org.robovm.debugger.utils.macho.tools.ExportedSymbolsParser;

public class DyLdChainedFixups {
    static final int DYLD_CHAINED_IMPORT = 1;
    static final int DYLD_CHAINED_IMPORT_ADDEND = 2;
    static final int DYLD_CHAINED_IMPORT_ADDEND64 = 3;

    public static class PointerOnDisk
    extends Bits64 {
        public final long addr;
        public final Arm64e arm64e = new Arm64e();
        public final Generic64 generic64 = new Generic64();

        public PointerOnDisk(long addr, long val) {
            super(val);
            this.addr = addr;
        }

        public static int strideSize(short pointerFormat) {
            switch (pointerFormat) {
                case 1: 
                case 9: 
                case 12: {
                    return 8;
                }
                case 2: 
                case 3: 
                case 4: 
                case 5: 
                case 6: 
                case 7: 
                case 8: 
                case 10: {
                    return 4;
                }
                case 11: {
                    return 1;
                }
            }
            throw new IllegalArgumentException("unsupported pointer chain format " + pointerFormat);
        }

        public class Arm64e {
            public final AuthRebase authRebase = new AuthRebase();
            public final AuthBind authBind = new AuthBind();
            public final Rebase rebase = new Rebase();
            public final Bind bind = new Bind();

            public long signPointer(PointerOnDisk loc, long target) {
                assert (this.authBind.auth());
                return target;
            }

            public long signExtendedAddend() {
                assert (this.authBind.bind());
                assert (!this.authBind.auth());
                long addend19 = this.bind.addend();
                if ((addend19 & 0x40000L) != 0L) {
                    return addend19 | 0xFFFFFFFFFFFC0000L;
                }
                return addend19;
            }

            public long unpackTarget() {
                assert (!this.authBind.bind());
                assert (!this.authBind.auth());
                return this.rebase.high8() << 56 | this.rebase.target();
            }

            public class AuthRebase {
                public long target() {
                    return PointerOnDisk.this.getLongBits(32);
                }

                public int diversity() {
                    return PointerOnDisk.this.getIntBits(16, 32);
                }

                public boolean addrDiv() {
                    return PointerOnDisk.this.getBooleanBit(48);
                }

                public int key() {
                    return PointerOnDisk.this.getIntBits(2, 49);
                }

                public long next() {
                    return PointerOnDisk.this.getIntBits(11, 51);
                }

                public boolean bind() {
                    return PointerOnDisk.this.getBooleanBit(62);
                }

                public boolean auth() {
                    return PointerOnDisk.this.getBooleanBit(63);
                }
            }

            public class AuthBind {
                public int ordinal() {
                    return PointerOnDisk.this.getIntBits(16);
                }

                public int diversity() {
                    return PointerOnDisk.this.getIntBits(16, 32);
                }

                public boolean addrDiv() {
                    return PointerOnDisk.this.getBooleanBit(48);
                }

                public int key() {
                    return PointerOnDisk.this.getIntBits(2, 49);
                }

                public long next() {
                    return PointerOnDisk.this.getIntBits(11, 51);
                }

                public boolean bind() {
                    return PointerOnDisk.this.getBooleanBit(62);
                }

                public boolean auth() {
                    return PointerOnDisk.this.getBooleanBit(63);
                }
            }

            public class Rebase {
                public long target() {
                    return PointerOnDisk.this.getLongBits(43);
                }

                public long high8() {
                    return PointerOnDisk.this.getLongBits(8, 43);
                }

                public long next() {
                    return PointerOnDisk.this.getLongBits(11, 51);
                }

                public boolean bind() {
                    return PointerOnDisk.this.getBooleanBit(62);
                }

                public boolean auth() {
                    return PointerOnDisk.this.getBooleanBit(63);
                }
            }

            public class Bind {
                public int ordinal() {
                    return PointerOnDisk.this.getIntBits(16);
                }

                public long addend() {
                    return PointerOnDisk.this.getLongBits(19, 32);
                }

                public long next() {
                    return PointerOnDisk.this.getLongBits(11, 51);
                }

                public boolean bind() {
                    return PointerOnDisk.this.getBooleanBit(62);
                }

                public boolean auth() {
                    return PointerOnDisk.this.getBooleanBit(63);
                }
            }
        }

        public class Generic64 {
            public final Rebase rebase = new Rebase();
            public final Bind bind = new Bind();

            public long signExtendedAddend() {
                long addend27 = this.bind.addend();
                long top8Bits = addend27 & 0x7F80000L;
                long bottom19Bits = addend27 & 0x7FFFFL;
                return top8Bits << 13 | bottom19Bits << 37 >> 37 & 0xFFFFFFFFFFFFFFL;
            }

            public long unpackedTarget() {
                return this.rebase.high8() << 56 | this.rebase.target();
            }

            public String toString() {
                return "Generic64: raw=" + Long.toHexString(PointerOnDisk.this.raw);
            }

            public class Rebase {
                public long target() {
                    return PointerOnDisk.this.getLongBits(36);
                }

                public long high8() {
                    return PointerOnDisk.this.getLongBits(8, 36);
                }

                public long next() {
                    return PointerOnDisk.this.getLongBits(12, 51);
                }

                public boolean bind() {
                    return PointerOnDisk.this.getBooleanBit(63);
                }

                public String toString() {
                    return "Rebase: target=" + Long.toHexString(this.target()) + ", hig8h=" + Long.toHexString(this.high8()) + ", next=" + Long.toHexString(this.next()) + ", bind=" + this.bind();
                }
            }

            public class Bind {
                public int ordinal() {
                    return PointerOnDisk.this.getIntBits(24);
                }

                public long addend() {
                    return PointerOnDisk.this.getLongBits(8, 24);
                }

                public long next() {
                    return PointerOnDisk.this.getLongBits(12, 51);
                }

                public boolean bind() {
                    return PointerOnDisk.this.getBooleanBit(63);
                }

                public String toString() {
                    return "Bind: ordinal=" + Long.toHexString(this.ordinal()) + ", addend=" + Long.toHexString(this.addend()) + ", next=" + Long.toHexString(this.next()) + ", bind=" + this.bind();
                }
            }
        }
    }

    public static class StartsInSegment {
        public final short page_size;
        public final short pointer_format;
        public final long segment_offset;
        public final long max_valid_pointer;
        public final short[] page_starts;

        public StartsInSegment(DataBufferReader reader) {
            int size = reader.readInt32();
            this.page_size = reader.readInt16();
            this.pointer_format = reader.readInt16();
            this.segment_offset = reader.readLong();
            this.max_valid_pointer = reader.readInt32();
            int page_count = reader.readInt16();
            this.page_starts = new short[page_count];
            for (int i = 0; i < page_count; ++i) {
                this.page_starts[i] = reader.readInt16();
            }
        }
    }

    public static class Header {
        public final StartsInSegment[] startsInSegment;
        public final Long[] imports;

        public Header(DataBufferReader reader, Map<String, ExportedSymbolsParser.ResolvedSymbol> knownSymbols) {
            boolean symbolsCompressed;
            long start = reader.position();
            int fixups_version = reader.readInt32();
            long starts_offset = reader.readUnsignedInt32();
            long imports_offset = reader.readUnsignedInt32();
            long symbols_offset = reader.readUnsignedInt32();
            int imports_count = reader.readInt32();
            int imports_format = reader.readInt32();
            boolean bl = symbolsCompressed = reader.readInt32() == 1;
            if (symbolsCompressed) {
                throw new UnsupportedOperationException("Compressed symbols not supported at moment");
            }
            this.startsInSegment = this.parseChainedStartsInImage(reader.setPosition(starts_offset));
            DataBufferReader stringReader = reader.setPosition(start + symbols_offset).slice();
            this.imports = this.parseImports(imports_format, reader.setPosition(start + imports_offset), stringReader, imports_count, knownSymbols);
        }

        private StartsInSegment[] parseChainedStartsInImage(DataBufferReader reader) {
            long start = reader.position();
            int seg_count = reader.readInt32();
            ArrayList<StartsInSegment> chainedStars = new ArrayList<StartsInSegment>(seg_count);
            for (int i = 0; i < seg_count; ++i) {
                int offset = reader.readInt32();
                if (offset == 0) continue;
                long savedPos = reader.position();
                reader.setPosition(start + (long)offset);
                chainedStars.add(new StartsInSegment(reader));
                reader.setPosition(savedPos);
            }
            return chainedStars.toArray(new StartsInSegment[0]);
        }

        private Long[] parseImports(int format, DataBufferReader reader, DataBufferReader stringReader, int count, Map<String, ExportedSymbolsParser.ResolvedSymbol> knownSymbols) {
            Long[] imports = new Long[count];
            for (int i = 0; i < count; ++i) {
                imports[i] = this.parseSingleImport(format, reader, stringReader, knownSymbols);
            }
            return imports;
        }

        private Long parseSingleImport(int format, DataBufferReader reader, DataBufferReader stringReader, Map<String, ExportedSymbolsParser.ResolvedSymbol> knownSymbols) {
            ExportedSymbolsParser.ResolvedSymbol resolvedSymbol;
            long addend;
            String symbolName;
            boolean weak_import;
            int lib_ordinal;
            switch (format) {
                case 1: {
                    long v = reader.readUnsignedInt32();
                    lib_ordinal = (int)(v & 0xFFL);
                    weak_import = (v >> 8 & 1L) == 1L;
                    long name_offset = v >> 9 & 0x7FFFFFL;
                    symbolName = stringReader.setPosition(name_offset).readStringZ();
                    addend = 0L;
                    break;
                }
                case 2: {
                    long v = reader.readUnsignedInt32();
                    lib_ordinal = (int)(v & 0xFFL);
                    weak_import = (v >> 8 & 1L) == 1L;
                    long name_offset = v >> 9 & 0x7FFFFFL;
                    symbolName = stringReader.setPosition(name_offset).readStringZ();
                    addend = reader.readUnsignedInt32();
                    break;
                }
                case 3: {
                    long v = reader.readUnsignedInt32();
                    lib_ordinal = (int)(v & 0xFFL);
                    weak_import = (v >> 8 & 1L) == 1L;
                    long name_offset = v >> 9 & 0x7FFFFFL;
                    symbolName = stringReader.setPosition(name_offset).readStringZ();
                    addend = reader.readLong();
                    break;
                }
                default: {
                    return null;
                }
            }
            if (lib_ordinal == 0 && !weak_import && (resolvedSymbol = knownSymbols.get(symbolName)) != null) {
                switch (resolvedSymbol.kind) {
                    case REGULAR: 
                    case ABSOLUTE: {
                        return resolvedSymbol.target + addend;
                    }
                    case THREAD_LOCAL: {
                        return resolvedSymbol.target;
                    }
                }
            }
            return null;
        }
    }
}

