/*
 * Decompiled with CFR 0.152.
 */
package org.robovm.debugger.utils.macho.tools;

import org.robovm.debugger.utils.bytebuffer.DataBufferReaderWriter;
import org.robovm.debugger.utils.macho.structs.DyLdChainedFixups;

public class ChainedFixup {
    private final DataBufferReaderWriter readerWriter;
    private final long imageBaseAddress;

    public ChainedFixup(long imageBaseAddress, DataBufferReaderWriter readerWriter) {
        this.imageBaseAddress = imageBaseAddress;
        this.readerWriter = readerWriter;
    }

    private DyLdChainedFixups.PointerOnDisk getFixupPointerAt(long addr) {
        long val = this.readerWriter.setPosition(addr).readPointer();
        return new DyLdChainedFixups.PointerOnDisk(addr, val);
    }

    private void applyFixup(DyLdChainedFixups.PointerOnDisk ptr, long value) {
        if (ptr.raw != value) {
            this.readerWriter.setPosition(ptr.addr).writePointer(value);
        }
    }

    public void fixupAllChainedFixups(DyLdChainedFixups.StartsInSegment[] starts, long slide, Long[] bindTargets) {
        for (DyLdChainedFixups.StartsInSegment segInfo : starts) {
            for (int pageIndex = 0; pageIndex < segInfo.page_starts.length; ++pageIndex) {
                short offsetInPage = segInfo.page_starts[pageIndex];
                if (offsetInPage == -1) continue;
                if ((offsetInPage & 0x8000) != 0) {
                    throw new IllegalArgumentException("32bit DYLD_CHAINED_PTR_START_MULTI are not supported!");
                }
                long pageContentStart = this.imageBaseAddress + segInfo.segment_offset + (long)pageIndex * (long)segInfo.page_size;
                DyLdChainedFixups.PointerOnDisk chain = this.getFixupPointerAt(pageContentStart + (long)offsetInPage);
                this.walkChain(chain, segInfo.pointer_format, bindTargets, slide);
            }
        }
    }

    private void walkChain(DyLdChainedFixups.PointerOnDisk chain, short pointer_format, Long[] bindTargets, long slide) {
        int stride = DyLdChainedFixups.PointerOnDisk.strideSize(pointer_format);
        boolean chainEnd = false;
        block4: while (!chainEnd) {
            this.handleFixupLocation(chain, pointer_format, bindTargets, slide);
            switch (pointer_format) {
                case 1: 
                case 7: 
                case 9: 
                case 10: 
                case 12: {
                    if (chain.arm64e.rebase.next() == 0L) {
                        chainEnd = true;
                        continue block4;
                    }
                    chain = this.getFixupPointerAt(chain.addr + chain.arm64e.rebase.next() * (long)stride);
                    continue block4;
                }
                case 2: 
                case 6: {
                    if (chain.generic64.rebase.next() == 0L) {
                        chainEnd = true;
                        continue block4;
                    }
                    chain = this.getFixupPointerAt(chain.addr + chain.generic64.rebase.next() * (long)stride);
                    continue block4;
                }
            }
            throw new Error("unknown pointer format " + pointer_format);
        }
    }

    private void handleFixupLocation(DyLdChainedFixups.PointerOnDisk fixupLoc, short pointer_format, Long[] bindTargets, long slide) {
        switch (pointer_format) {
            case 1: 
            case 7: 
            case 9: {
                long newValue;
                if (fixupLoc.arm64e.authRebase.auth()) {
                    if (fixupLoc.arm64e.authBind.bind()) {
                        Long bindTarget = bindTargets[fixupLoc.arm64e.authBind.ordinal()];
                        if (bindTarget == null) {
                            return;
                        }
                        newValue = bindTarget;
                        if (newValue != 0L) {
                            newValue = fixupLoc.arm64e.signPointer(fixupLoc, newValue);
                        }
                    } else {
                        newValue = fixupLoc.arm64e.signPointer(fixupLoc, this.imageBaseAddress + fixupLoc.arm64e.authRebase.target());
                    }
                } else if (fixupLoc.arm64e.bind.bind()) {
                    Long bindTarget = bindTargets[fixupLoc.arm64e.bind.ordinal()];
                    if (bindTarget == null) {
                        return;
                    }
                    newValue = bindTarget + fixupLoc.arm64e.signExtendedAddend();
                } else {
                    newValue = pointer_format == 1 ? fixupLoc.arm64e.unpackTarget() + slide : this.imageBaseAddress + fixupLoc.arm64e.unpackTarget();
                }
                this.applyFixup(fixupLoc, newValue);
                break;
            }
            case 2: 
            case 6: {
                long newValue;
                if (fixupLoc.generic64.bind.bind()) {
                    Long bindTarget = bindTargets[fixupLoc.generic64.bind.ordinal()];
                    if (bindTarget == null) {
                        return;
                    }
                    newValue = bindTarget + fixupLoc.generic64.signExtendedAddend();
                } else {
                    newValue = pointer_format == 2 ? fixupLoc.generic64.unpackedTarget() + slide : this.imageBaseAddress + fixupLoc.generic64.unpackedTarget();
                }
                this.applyFixup(fixupLoc, newValue);
                break;
            }
            default: {
                throw new IllegalArgumentException("unsupported pointer chain format: " + pointer_format);
            }
        }
    }
}

