/*
 * Decompiled with CFR 0.152.
 */
package org.robovm.debugger.utils.macho.tools;

import java.util.HashSet;
import java.util.Set;
import java.util.function.Predicate;
import org.robovm.debugger.utils.bytebuffer.DataBufferReader;

public final class Trie {
    private static boolean walkNode(DataBufferReader trie, Set<Long> visitedNodeOffsets, String nodeName, Predicate<String> shouldContinueToChild, TrieIterator iterator) {
        visitedNodeOffsets.add(trie.position());
        long terminalSize = trie.readUleb128();
        if (terminalSize != 0L) {
            long savedPos = trie.position();
            if (!iterator.handle(nodeName, trie, (int)terminalSize)) {
                return false;
            }
            trie.setPosition(savedPos + terminalSize);
        }
        for (byte childrenCount = trie.readByte(); childrenCount > 0; childrenCount = (byte)(childrenCount - 1)) {
            String childSuffix = trie.readStringZ();
            String childName = nodeName + childSuffix;
            long nodeOffset = trie.readUleb128();
            if (!shouldContinueToChild.test(childName)) continue;
            long savedPos = trie.position();
            trie.setPosition(nodeOffset);
            if (!Trie.walkNode(trie, visitedNodeOffsets, childName, shouldContinueToChild, iterator)) {
                return false;
            }
            trie.setPosition(savedPos);
        }
        return true;
    }

    public static void forEach(DataBufferReader trie, TrieIterator iterator) {
        HashSet<Long> visitedNodeOffsets = new HashSet<Long>();
        Trie.walkNode(trie, visitedNodeOffsets, "", name -> true, iterator);
    }

    public static <T> T find(DataBufferReader trie, String key, Mapper<T> mapper) {
        HashSet<Long> visitedNodeOffsets = new HashSet<Long>();
        Object[] result = new Object[]{null};
        Trie.walkNode(trie, visitedNodeOffsets, "", key::startsWith, (name, data, size) -> {
            if (name.equals(key)) {
                result[0] = mapper.map(data, size);
                return false;
            }
            return true;
        });
        return (T)result[0];
    }

    public static interface TrieIterator {
        public boolean handle(String var1, DataBufferReader var2, int var3);
    }

    public static interface Mapper<T> {
        public T map(DataBufferReader var1, int var2);
    }
}

