/*
 * Decompiled with CFR 0.152.
 */
package org.robovm.debugger.jdwp.handlers.eventrequest.events;

import org.robovm.debugger.jdwp.handlers.eventrequest.events.EventData;
import org.robovm.debugger.state.classdata.ClassInfo;
import org.robovm.debugger.state.classdata.ClassInfoImpl;
import org.robovm.debugger.state.instances.VmThread;
import org.robovm.debugger.utils.bytebuffer.DataBufferWriter;

public class JdwpEventData
extends EventData {
    private final byte eventKind;
    private final VmThread thread;

    public JdwpEventData(byte eventKind, VmThread thread) {
        this.eventKind = eventKind;
        this.thread = thread;
    }

    public void dump(DataBufferWriter packet, int requestId) {
        packet.writeByte(this.eventKind);
        packet.writeInt32(requestId);
        packet.writeLong(this.getThreadRefId());
        this.dumpCustomData(packet);
    }

    protected void dumpCustomData(DataBufferWriter packet) {
    }

    public byte eventKind() {
        return this.eventKind;
    }

    public VmThread thread() {
        return this.thread;
    }

    @Override
    public long getThreadRefId() {
        return this.thread != null ? this.thread.refId() : 0L;
    }

    public boolean cancelIfNotHandled() {
        return false;
    }

    protected String makeClassName(ClassInfo classInfo) {
        if (classInfo instanceof ClassInfoImpl) {
            return ((ClassInfoImpl)classInfo).className().replace('/', '.');
        }
        return null;
    }
}

