/*
 * Decompiled with CFR 0.152.
 */
package org.robovm.debugger.jdwp.handlers.eventrequest.events;

import java.util.List;
import java.util.Set;
import org.robovm.debugger.jdwp.JdwpConsts;
import org.robovm.debugger.jdwp.handlers.eventrequest.events.EventData;
import org.robovm.debugger.jdwp.handlers.eventrequest.events.predicates.EventPredicate;

public class JdwpEventRequest {
    private final int requestId;
    private final byte eventKind;
    private final byte suspendPolicy;
    private final List<EventPredicate> predicates;
    private boolean canceled;
    private Set<String> filteredClassNames;

    public JdwpEventRequest(int requestId, byte eventKind, byte suspendPolicy, List<EventPredicate> predicates) {
        this.requestId = requestId;
        this.eventKind = eventKind;
        this.suspendPolicy = suspendPolicy;
        this.predicates = predicates;
    }

    public boolean test(EventData data) {
        for (EventPredicate predicate : this.predicates) {
            if (predicate.test(data)) continue;
            return false;
        }
        return true;
    }

    public boolean test(EventData data, int modifierKind) {
        for (EventPredicate predicate : this.predicates) {
            if (predicate.modifierKind() != modifierKind || predicate.test(data)) continue;
            return false;
        }
        return true;
    }

    public int requestId() {
        return this.requestId;
    }

    public byte eventKind() {
        return this.eventKind;
    }

    public byte suspendPolicy() {
        return this.suspendPolicy;
    }

    public List<EventPredicate> predicates() {
        return this.predicates;
    }

    public <T> T predicateByKind(byte modifierKind) {
        for (EventPredicate predicate : this.predicates) {
            if (predicate.modifierKind() != modifierKind) continue;
            return (T)predicate;
        }
        return null;
    }

    public boolean isCanceled() {
        return this.canceled;
    }

    public void setCanceled(boolean canceled) {
        this.canceled = canceled;
    }

    public String toString() {
        return "JdwpEventRequest{requestId=" + this.requestId + ", eventKind=" + JdwpConsts.stringEventKind(this.eventKind) + ", suspendPolicy=" + JdwpConsts.stringSuspendPolicy(this.suspendPolicy) + ", predicates=" + this.predicates + '}';
    }

    public void setFilteredClassNames(Set<String> filteredClassNames) {
        this.filteredClassNames = filteredClassNames;
    }

    public Set<String> filteredClassNames() {
        return this.filteredClassNames;
    }
}

