/*
 * Decompiled with CFR 0.152.
 */
package org.robovm.debugger.jdwp.handlers.referencetype;

import org.robovm.debugger.jdwp.protocol.IJdwpRequestHandler;
import org.robovm.debugger.state.VmDebuggerState;
import org.robovm.debugger.state.classdata.ClassInfo;
import org.robovm.debugger.state.classdata.ClassInfoImpl;
import org.robovm.debugger.utils.bytebuffer.DataBufferReader;
import org.robovm.debugger.utils.bytebuffer.DataBufferWriter;

public class JdwpRefTypeSourceFileHandler
implements IJdwpRequestHandler {
    private final VmDebuggerState state;

    public JdwpRefTypeSourceFileHandler(VmDebuggerState state) {
        this.state = state;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public short handle(DataBufferReader payload, DataBufferWriter output) {
        long referenceTypeID = payload.readLong();
        Object object = this.state.centralLock();
        synchronized (object) {
            ClassInfo classInfo = this.state.classInfoLoader().classInfoByRefId(referenceTypeID);
            if (classInfo == null) {
                return 21;
            }
            if (!classInfo.isClass()) {
                return 21;
            }
            String sourceFile = ((ClassInfoImpl)classInfo).sourceFile();
            output.writeStringWithLen(sourceFile);
        }
        return 0;
    }

    @Override
    public byte getCommandSet() {
        return 2;
    }

    @Override
    public byte getCommand() {
        return 7;
    }

    public String toString() {
        return "ReferenceType(2).SourceFile(7)";
    }
}

