/*
 * Decompiled with CFR 0.152.
 */
package org.robovm.debugger.utils;

import java.util.ArrayList;
import org.robovm.debugger.delegates.AllDelegates;
import org.robovm.debugger.hooks.HookConsts;
import org.robovm.debugger.hooks.payloads.HooksCallStackEntry;
import org.robovm.debugger.state.classdata.BaseModifiersInfo;
import org.robovm.debugger.state.classdata.ClassInfo;
import org.robovm.debugger.state.classdata.MethodInfo;
import org.robovm.debugger.state.instances.VmStackTrace;
import org.robovm.debugger.utils.DbgLogger;

public final class StackTraceConverter {
    public static VmStackTrace[] convertCallStack(int eventId, HooksCallStackEntry[] callStack, AllDelegates delegates, DbgLogger log) {
        ArrayList<VmStackTrace> result = new ArrayList<VmStackTrace>();
        for (HooksCallStackEntry entry : callStack) {
            VmStackTrace stackTrace = StackTraceConverter.convertStackTrace(eventId, entry, delegates, log);
            if (stackTrace == null) continue;
            result.add(stackTrace);
        }
        if (result.size() == 0) {
            log.error(HookConsts.commandToString(eventId) + ": Empty callstack!");
        }
        return result.toArray(new VmStackTrace[0]);
    }

    private static VmStackTrace convertStackTrace(int eventId, HooksCallStackEntry payload, AllDelegates delegates, DbgLogger log) {
        String signature = "L" + payload.clazzName() + ";";
        ClassInfo classInfo = delegates.state().classInfoLoader().classInfoBySignature(signature);
        if (classInfo == null) {
            log.error(HookConsts.commandToString(eventId) + ": Failed to get get stack entry. Class is not known " + payload.clazzName());
            return null;
        }
        MethodInfo[] methods = delegates.state().classInfoLoader().classMethods(classInfo);
        long implPtr = delegates.runtime().toMachOAddr(payload.impl());
        BaseModifiersInfo methodInfo = null;
        for (MethodInfo mi : methods) {
            if (mi.implPtr() != implPtr) continue;
            methodInfo = mi;
            break;
        }
        if (methodInfo == null) {
            log.error(HookConsts.commandToString(eventId) + ": Failed to get get stack entry. Method not found for impl " + Long.toHexString(payload.impl()) + " class " + payload.clazzName());
            return null;
        }
        if (methodInfo.isBridge() || ((MethodInfo)methodInfo).isBroCallback() || ((MethodInfo)methodInfo).isBroBridge()) {
            return null;
        }
        return new VmStackTrace(classInfo, (MethodInfo)methodInfo, payload.lineNumber(), payload.fp(), payload.pc() - payload.impl());
    }
}

