/*
 * Decompiled with CFR 0.152.
 */
package org.robovm.debugger.utils.bytebuffer;

import java.nio.ByteOrder;

public interface DataBuffer {
    public boolean is64bit();

    default public int pointerSize() {
        return this.is64bit() ? 8 : 4;
    }

    public long position();

    default public long bottomLimit() {
        return 0L;
    }

    public long limit();

    default public DataBuffer reset() {
        this.setPosition(this.bottomLimit());
        return this;
    }

    public DataBuffer setPosition(long var1);

    default public boolean hasRemaining() {
        return this.position() < this.limit();
    }

    default public int remaining() {
        return (int)(this.limit() - this.position());
    }

    default public int size() {
        return (int)(this.limit() - this.bottomLimit());
    }

    default public boolean hasArray() {
        return false;
    }

    default public byte[] array() {
        throw new UnsupportedOperationException();
    }

    default public int arrayOffset() {
        throw new UnsupportedOperationException();
    }

    default public int arrayPositionOffset() {
        return this.arrayOffset() + (int)(this.position() - this.bottomLimit());
    }

    public DataBuffer setByteOrder(ByteOrder var1);
}

