/*
 * Decompiled with CFR 0.152.
 */
package org.robovm.debugger.utils.bytebuffer;

import java.nio.BufferUnderflowException;
import java.nio.ByteOrder;
import java.util.Arrays;
import org.robovm.debugger.utils.bytebuffer.DataBufferReader;

public class NullDataBufferReader
implements DataBufferReader {
    final boolean is64bit;
    final long bottomLimit;
    final long limit;
    long position;

    public NullDataBufferReader(long bottomLimit, long size, boolean is64bit) {
        this.bottomLimit = bottomLimit;
        this.limit = bottomLimit + size;
        this.is64bit = is64bit;
    }

    private void expectAndAdvance(int byteCount) {
        this.expects(byteCount);
        this.position += (long)byteCount;
    }

    @Override
    public byte readByte() {
        this.expectAndAdvance(1);
        return 0;
    }

    @Override
    public short readInt16() {
        this.expectAndAdvance(2);
        return 0;
    }

    @Override
    public int readInt32() {
        this.expectAndAdvance(4);
        return 0;
    }

    @Override
    public long readLong() {
        this.expectAndAdvance(8);
        return 0L;
    }

    @Override
    public float readFloat() {
        this.expectAndAdvance(4);
        return 0.0f;
    }

    @Override
    public double readDouble() {
        this.expectAndAdvance(8);
        return 0.0;
    }

    @Override
    public NullDataBufferReader sliceAt(long pos, int size, long newBottomLimit, boolean as64bit) {
        if (pos < this.bottomLimit || this.position >= this.limit) {
            throw new IndexOutOfBoundsException();
        }
        if (pos + (long)size > this.limit) {
            throw new BufferUnderflowException();
        }
        return new NullDataBufferReader(newBottomLimit, size, as64bit);
    }

    @Override
    public boolean is64bit() {
        return this.is64bit;
    }

    @Override
    public long position() {
        return this.position;
    }

    @Override
    public long bottomLimit() {
        return this.bottomLimit;
    }

    @Override
    public long limit() {
        return this.limit;
    }

    @Override
    public NullDataBufferReader setPosition(long position) {
        if (position < this.bottomLimit || position >= this.limit) {
            throw new IndexOutOfBoundsException(Long.toString(position));
        }
        return this;
    }

    @Override
    public NullDataBufferReader setByteOrder(ByteOrder order) {
        return this;
    }

    @Override
    public void readBytes(byte[] dst, int offset, int length) {
        this.expectAndAdvance(length);
        Arrays.fill(dst, offset, offset + length, (byte)0);
    }

    public String toString() {
        return "NullDataBufferReader{" + Long.toHexString(this.bottomLimit) + " ... " + Long.toHexString(this.limit() - 1L) + '}';
    }
}

