/*
 * Decompiled with CFR 0.152.
 */
package org.robovm.debugger.utils.macho.tools;

import java.util.Map;
import org.robovm.debugger.utils.bytebuffer.DataBufferArrayReader;
import org.robovm.debugger.utils.bytebuffer.DataBufferReader;
import org.robovm.debugger.utils.macho.MachOConsts;
import org.robovm.debugger.utils.macho.cmds.SymtabCommand;
import org.robovm.debugger.utils.macho.structs.NList;
import org.robovm.debugger.utils.macho.tools.Trie;

public final class ExportedSymbolsParser {
    public static void parseSymtabCommand(Map<String, ResolvedSymbol> dest, DataBufferReader reader, SymtabCommand symtabCommand, boolean is64b) {
        DataBufferReader stringReader;
        if (symtabCommand.strsize < 0x800000L) {
            byte[] symtabBytes = reader.setPosition(symtabCommand.stroff).readBytes((int)symtabCommand.strsize);
            stringReader = DataBufferReader.wrap(symtabBytes);
        } else {
            stringReader = reader.sliceAt(symtabCommand.stroff, (int)symtabCommand.strsize);
        }
        DataBufferReader nlistReader = reader.sliceAt(symtabCommand.symoff, (int)(symtabCommand.nsyms * (long)NList.ITEM_SIZE(is64b)));
        DataBufferArrayReader<NList> arrayReader = new DataBufferArrayReader<NList>(nlistReader, NList.ITEM_SIZE(is64b), NList.OBJECT_READER(is64b));
        for (NList nlist2 : arrayReader) {
            String sym;
            if (!nlist2.isTypeStab() ? nlist2.isTypeUndfined() || nlist2.isTypePreboundUndefined() : !nlist2.isTypeStabGlobalSymb()) continue;
            if (nlist2.n_sect() == 0 || !ExportedSymbolsParser.isUsableDebuggerSym(sym = stringReader.readStringZ(nlist2.n_strx()))) continue;
            MachOConsts.ExportSymbolKind kind = MachOConsts.ExportSymbolKind.ABSOLUTE;
            long target = nlist2.n_value();
            ResolvedSymbol resolved = new ResolvedSymbol(sym, kind, target);
            dest.put(sym, resolved);
        }
    }

    public static void parseExportTrie(Map<String, ResolvedSymbol> dest, DataBufferReader trie) {
        Trie.forEach(trie, (symbolName, data, size) -> {
            if (ExportedSymbolsParser.isUsableDebuggerSym(symbolName)) {
                boolean accept;
                DataBufferReader symbolData = data.slice(size);
                int flags = (int)symbolData.readUleb128();
                MachOConsts.ExportSymbolKind kind = MachOConsts.ExportSymbolKind.values()[flags & 3];
                boolean bl = accept = (flags & 8) == 0 && (flags & 4) == 0 && (flags & 0x10) != 0;
                if (accept) {
                    long target = symbolData.readUleb128();
                    ResolvedSymbol resolved = new ResolvedSymbol(symbolName, kind, target);
                    dest.put(symbolName, resolved);
                }
            }
            return true;
        });
    }

    private static boolean isUsableDebuggerSym(String sym) {
        return sym.endsWith("[debuginfo]") || sym.endsWith("[bptable]") || sym.startsWith("_prim_") || sym.equals("__bcBootClassesHash") || sym.equals("__bcClassesHash") || sym.equals("_robovmBaseSymbol");
    }

    public static class ResolvedSymbol {
        public final String symbolName;
        public final MachOConsts.ExportSymbolKind kind;
        public final long target;

        public ResolvedSymbol(String symbolName, MachOConsts.ExportSymbolKind kind, long target) {
            this.symbolName = symbolName;
            this.kind = kind;
            this.target = target;
        }
    }
}

