/*
 * Decompiled with CFR 0.152.
 */
package org.robovm.debugger.delegates;

import java.nio.ByteOrder;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import org.robovm.debugger.DebuggerException;
import org.robovm.debugger.delegates.AllDelegates;
import org.robovm.debugger.hooks.payloads.HooksCmdResponse;
import org.robovm.debugger.runtime.ValueManipulator;
import org.robovm.debugger.state.classdata.ClassInfo;
import org.robovm.debugger.state.classdata.ClassInfoArrayImpl;
import org.robovm.debugger.state.classdata.ClassInfoImpl;
import org.robovm.debugger.state.classdata.ClassInfoLoader;
import org.robovm.debugger.state.classdata.ClassInfoPrimitiveImpl;
import org.robovm.debugger.state.classdata.FieldInfo;
import org.robovm.debugger.state.classdata.MethodInfo;
import org.robovm.debugger.state.classdata.RuntimeClassInfoLoader;
import org.robovm.debugger.state.instances.VmArrayInstance;
import org.robovm.debugger.state.instances.VmClassInstance;
import org.robovm.debugger.state.instances.VmClassLoaderInstance;
import org.robovm.debugger.state.instances.VmInstance;
import org.robovm.debugger.state.instances.VmStringInstance;
import org.robovm.debugger.state.instances.VmThread;
import org.robovm.debugger.state.instances.VmThreadGroup;
import org.robovm.debugger.utils.Converter;
import org.robovm.debugger.utils.bytebuffer.ByteBufferPacket;
import org.robovm.debugger.utils.bytebuffer.ByteBufferReader;

public class InstanceUtils {
    private final AllDelegates delegates;
    private Map<Long, Instantiator> instantiatorForClassRefId = new HashMap<Long, Instantiator>();
    private final RuntimeClassInfoLoader runtimeClassInfoLoader;
    private final Manipulator manipulator;

    public InstanceUtils(AllDelegates delegates) {
        this.delegates = delegates;
        this.runtimeClassInfoLoader = new RuntimeClassInfoLoader(delegates);
        this.manipulator = new Manipulator(this);
    }

    public RuntimeClassInfoLoader classInfoLoader() {
        return this.runtimeClassInfoLoader;
    }

    public VmStringInstance createVmStringInstance(String value) {
        VmThread thread = this.delegates.threads().anySuspendedThread();
        if (thread == null) {
            throw new DebuggerException(113);
        }
        HooksCmdResponse res = this.delegates.hooksApi().newString(thread.threadPtr(), value);
        if (res.exceptionPrt() != 0L || res.result() == null) {
            throw new DebuggerException(113);
        }
        ClassInfo classInfo = this.delegates.state().classInfoLoader().classInfoBySignature("Ljava/lang/String;");
        VmStringInstance stringInstance = (VmStringInstance)this.delegates.instances().instanceByPointer((Long)res.result(), classInfo, null, true);
        return stringInstance;
    }

    public String readStringValue(VmStringInstance stringInstance) {
        if (stringInstance.value() != null) {
            return stringInstance.value();
        }
        long objectPtr = stringInstance.objectPtr();
        ClassInfo ci = stringInstance.classInfo();
        VmArrayInstance value = (VmArrayInstance)this.getFieldValue(objectPtr, ci, "value");
        int count = (Integer)this.getFieldValue(objectPtr, ci, "count");
        int offset = (Integer)this.getFieldValue(objectPtr, ci, "offset");
        String str = count == 0 ? "" : this.delegates.arrays().readArrayString(value, offset, count);
        stringInstance.setValue(str);
        return str;
    }

    public String readStringValue(long stringRefId) {
        VmStringInstance stringInstance = (VmStringInstance)this.delegates.state().referenceRefIdHolder().instanceById(stringRefId);
        if (stringInstance == null) {
            throw new DebuggerException(20);
        }
        return this.readStringValue(stringInstance);
    }

    public <T> T getFieldValue(long objectPtr, ClassInfo ci, String fieldName) throws DebuggerException {
        FieldInfo fi = ci.getField(fieldName, this.runtimeClassInfoLoader.loader());
        if (fi == null) {
            throw new DebuggerException("Field " + fieldName + " not found in " + ci.signature());
        }
        return this.getFieldValue(objectPtr, ci, fi);
    }

    public <T> T getFieldValue(long objectPtr, ClassInfo ci, FieldInfo fi) throws DebuggerException {
        return this.getFieldValue(objectPtr, ci, fi, null);
    }

    private <T> T getFieldValue(long objectPtr, ClassInfo ci, FieldInfo fi, ByteBufferPacket jdwpOutput) throws DebuggerException {
        String signature = fi.signature();
        ClassInfo fieldTypeInfo = fi.typeInfo();
        if (fieldTypeInfo == null) {
            fieldTypeInfo = this.runtimeClassInfoLoader.loader().classInfoBySignature(signature);
        }
        if (fieldTypeInfo == null && !ClassInfoLoader.isArraySignature(signature)) {
            if (ClassInfoLoader.isPrimitiveSignature(signature)) {
                fieldTypeInfo = this.runtimeClassInfoLoader.buildPrimitiveClassInfo(signature.charAt(0));
            } else {
                throw new DebuggerException("Failed to resolve type info for field " + fi.name() + " in " + ci.signature());
            }
        }
        return (T)this.getMemoryValue(objectPtr + (long)fi.offset(), fieldTypeInfo, jdwpOutput);
    }

    public Object getMemoryValue(long objectPtr, ClassInfo ci, ByteBufferPacket jdwpOutput) {
        ValueManipulator valueManipulator;
        this.delegates.runtime().deviceMemoryReader().setAddress(objectPtr);
        if (ci != null && ci.isPrimitive()) {
            ClassInfoPrimitiveImpl primitiveInfo = (ClassInfoPrimitiveImpl)ci;
            valueManipulator = primitiveInfo.manipulator();
        } else {
            valueManipulator = this.manipulator;
        }
        Object result = valueManipulator.readFromDevice(this.delegates.runtime().deviceMemoryReader());
        if (jdwpOutput != null) {
            valueManipulator.writeToJdwp(jdwpOutput, result);
        }
        return result;
    }

    public void jdwpFieldGetValues(long objectOrClassId, long[] fields2, boolean isStatic, ByteBufferPacket packet) {
        FieldInfo fieldInfo;
        long baseDataPointer;
        ClassInfo ci;
        if (isStatic) {
            ci = this.delegates.state().classRefIdHolder().objectById(objectOrClassId);
            if (ci == null) {
                throw new DebuggerException(21);
            }
            if (ci.clazzPtr() == 0L) {
                throw new DebuggerException(22);
            }
            baseDataPointer = ci.clazzPtr();
        } else {
            Object instance = this.delegates.state().referenceRefIdHolder().instanceById(objectOrClassId);
            if (instance == null) {
                throw new DebuggerException(20);
            }
            baseDataPointer = ((VmInstance)instance).objectPtr();
            ci = ((VmInstance)instance).classInfo();
        }
        for (long fieldId : fields2) {
            fieldInfo = this.delegates.state().fieldRefIdHolder().objectById(fieldId);
            if (fieldInfo == null) {
                throw new DebuggerException(25);
            }
            if (fieldInfo.isStatic() == isStatic) continue;
            throw new DebuggerException(25);
        }
        for (long fieldId : fields2) {
            fieldInfo = this.delegates.state().fieldRefIdHolder().objectById(fieldId);
            this.getFieldValue(baseDataPointer, ci, fieldInfo, packet);
        }
    }

    private void setFieldValue(long objectPtr, ClassInfo ci, FieldInfo fi, Object value, ByteBufferReader fromJdpw) throws DebuggerException {
        String signature = fi.signature();
        ClassInfo fieldTypeInfo = fi.typeInfo();
        if (fieldTypeInfo == null) {
            fieldTypeInfo = this.runtimeClassInfoLoader.loader().classInfoBySignature(signature);
        }
        if (fieldTypeInfo == null && !ClassInfoLoader.isArraySignature(signature)) {
            if (ClassInfoLoader.isPrimitiveSignature(signature)) {
                fieldTypeInfo = this.runtimeClassInfoLoader.buildPrimitiveClassInfo(signature.charAt(0));
            } else {
                throw new DebuggerException("Failed to resolve type info for field " + fi.name() + " in " + ci.signature());
            }
        }
        this.setMemoryValue(objectPtr + (long)fi.offset(), fieldTypeInfo, value, fromJdpw);
    }

    public void setMemoryValue(long objectPtr, ClassInfo ci, Object value, ByteBufferReader fromJdpw) {
        ValueManipulator valueManipulator;
        if (ci != null && ci.isPrimitive()) {
            ClassInfoPrimitiveImpl primitiveInfo = (ClassInfoPrimitiveImpl)ci;
            valueManipulator = primitiveInfo.manipulator();
        } else {
            valueManipulator = this.manipulator;
        }
        if (fromJdpw != null) {
            value = valueManipulator.readFromJdwp(fromJdpw);
        }
        ByteBufferPacket packet = this.delegates.sharedTargetPacket();
        packet.reset();
        valueManipulator.writeToDevice(packet, value);
        this.delegates.hooksApi().writeMemory(objectPtr, packet);
    }

    public void jdwpFieldSetValues(long objectOrClassId, int fieldsCount, boolean isStatic, ByteBufferPacket payload) {
        long baseDataPointer;
        ClassInfo ci;
        if (isStatic) {
            ci = this.delegates.state().classRefIdHolder().objectById(objectOrClassId);
            if (ci == null) {
                throw new DebuggerException(21);
            }
            if (ci.clazzPtr() == 0L) {
                throw new DebuggerException(22);
            }
            baseDataPointer = ci.clazzPtr();
        } else {
            Object instance = this.delegates.state().referenceRefIdHolder().instanceById(objectOrClassId);
            if (instance == null) {
                throw new DebuggerException(20);
            }
            baseDataPointer = ((VmInstance)instance).objectPtr();
            ci = ((VmInstance)instance).classInfo();
        }
        while (fieldsCount-- > 0) {
            long fieldId = payload.readLong();
            FieldInfo fieldInfo = this.delegates.state().fieldRefIdHolder().objectById(fieldId);
            this.setFieldValue(baseDataPointer, ci, fieldInfo, null, payload);
        }
    }

    public <T extends VmInstance> T existingInstanceByPointer(long objectPtr) throws ClassCastException {
        Object instance = this.delegates.state().referenceRefIdHolder().instanceByAddr(objectPtr);
        if (instance == null) {
            throw new DebuggerException(20);
        }
        return instance;
    }

    public VmClassInstance getClazzObject(long referenceTypeId) {
        ClassInfo referenceType = this.delegates.state().classRefIdHolder().objectById(referenceTypeId);
        if (referenceType == null) {
            throw new DebuggerException(21);
        }
        if (referenceType.clazzPtr() == 0L) {
            throw new DebuggerException(22);
        }
        return (VmClassInstance)this.instanceByPointer(referenceType.clazzPtr(), null, true);
    }

    public <T extends VmInstance> T instanceByPointer(long objectPtr, ClassInfo ci, Object param, boolean allocate) throws ClassCastException {
        if (objectPtr == 0L) {
            return null;
        }
        Object instance = this.delegates.state().referenceRefIdHolder().instanceByAddr(objectPtr);
        if (instance == null && allocate) {
            if (ci == null) {
                ci = this.runtimeClassInfoLoader.resolveObjectRuntimeDataTypeInfo(objectPtr);
            }
            if (ci == null) {
                throw new DebuggerException("Cannot resolve type for instance " + Long.toHexString(objectPtr));
            }
            if (ci.isPrimitive()) {
                throw new DebuggerException("Invalid case: object can't be primitive type " + Long.toHexString(objectPtr));
            }
            if (ci.isArray()) {
                instance = this.delegates.arrays().createArrayInstance(objectPtr, (ClassInfoArrayImpl)ci);
            } else {
                Instantiator instantiator = this.instantiatorForClass((ClassInfoImpl)ci);
                instance = instantiator.instance(ci, objectPtr, param);
            }
            this.delegates.state().referenceRefIdHolder().addObject((VmInstance)instance);
        }
        return instance;
    }

    public <T extends VmInstance> T instanceByPointer(long objectPtr, Object param, boolean allocate) throws ClassCastException {
        return this.instanceByPointer(objectPtr, null, param, allocate);
    }

    public <T extends VmInstance> T instanceByPointer(long objectPtr) throws ClassCastException {
        return this.instanceByPointer(objectPtr, null, null, true);
    }

    private Instantiator instantiatorForClass(ClassInfoImpl ci) {
        Instantiator res = this.instantiatorForClassRefId.get(ci.refId());
        if (res != null) {
            return res;
        }
        switch (ci.signature()) {
            case "Ljava/lang/String;": {
                res = this::createStringInstance;
                break;
            }
            case "Ljava/lang/Thread;": {
                res = this::createThreadInstance;
                break;
            }
            case "Ljava/lang/ThreadGroup;": {
                res = this::createThreadGroupInstance;
                break;
            }
            case "Ljava/lang/ClassLoader;": {
                res = this::createClassLoaderInstance;
                break;
            }
            case "Ljava/lang/Class;": {
                res = this::createClassInstance;
            }
        }
        if (res == null) {
            ClassInfoImpl superclass;
            String superclassSignature = ci.superclassSignature();
            if (superclassSignature != null && (superclass = (ClassInfoImpl)this.runtimeClassInfoLoader.loader().classInfoBySignature(superclassSignature)) != null) {
                res = this.instantiatorForClass(superclass);
            }
            if (res == null) {
                res = this::createGenericInstance;
            }
        }
        this.instantiatorForClassRefId.put(ci.refId(), res);
        return res;
    }

    public void jdwpInvokeMethod(long objectOrClassId, long threadId, long methodId, boolean isStatic, boolean singleThread, Object[] args, ByteBufferPacket output) {
        long classOrInstancePtr;
        VmThread thread = (VmThread)this.delegates.state().referenceRefIdHolder().instanceById(threadId);
        if (thread == null) {
            throw new DebuggerException(10);
        }
        if (thread.suspendCount() == 0) {
            throw new DebuggerException(13);
        }
        MethodInfo methodInfo = this.delegates.state().methodsRefIdHolder().objectById(methodId);
        if (methodInfo == null) {
            throw new DebuggerException(23);
        }
        if (isStatic) {
            ClassInfo ci = this.delegates.state().classRefIdHolder().objectById(objectOrClassId);
            if (ci == null) {
                throw new DebuggerException(21);
            }
            if (ci.clazzPtr() == 0L) {
                throw new DebuggerException(22);
            }
            classOrInstancePtr = ci.clazzPtr();
        } else {
            Object instance = this.delegates.state().referenceRefIdHolder().instanceById(objectOrClassId);
            if (instance == null) {
                throw new DebuggerException(20);
            }
            classOrInstancePtr = ((VmInstance)instance).objectPtr();
        }
        MethodInfo.CallSpec callspec = methodInfo.callspec();
        if (callspec == null) {
            callspec = this.buildCallSpec(methodInfo.signature());
            methodInfo.setCallspec(callspec);
        }
        if (args.length != callspec.arguments.length) {
            throw new DebuggerException(23);
        }
        ByteBufferPacket argsBuffer = null;
        if (args.length > 0) {
            argsBuffer = new ByteBufferPacket(args.length * 8, true);
            argsBuffer.setByteOrder(ByteOrder.LITTLE_ENDIAN);
            for (int idx = 0; idx < args.length; ++idx) {
                ValueManipulator valueManipulator;
                ClassInfo valueClassInfo = callspec.arguments[idx];
                Object value = args[idx];
                if (valueClassInfo.isPrimitive()) {
                    ClassInfoPrimitiveImpl primitiveInfo = (ClassInfoPrimitiveImpl)valueClassInfo;
                    valueManipulator = primitiveInfo.manipulator();
                } else {
                    value = this.delegates.state().referenceRefIdHolder().instanceById((Long)value);
                    valueManipulator = this.manipulator;
                }
                int pos = argsBuffer.position();
                argsBuffer.writeLong(0L);
                argsBuffer.setPosition(pos);
                valueManipulator.writeToDevice(argsBuffer, value);
                argsBuffer.setPosition(argsBuffer.size());
            }
        }
        boolean createInstance = isStatic && "<init>".equals(methodInfo.name());
        ClassInfo specReturnType = callspec.returnType;
        if (specReturnType == null && createInstance) {
            specReturnType = ClassInfoImpl.EMPTY;
        }
        byte returnType = specReturnType == null ? (byte)((byte)("<init>".equals(methodInfo.name()) ? 76 : 86)) : (specReturnType.isPrimitive() ? (byte)((byte)callspec.returnType.signature().charAt(0)) : (byte)76);
        if (!singleThread) {
            this.delegates.threads().resumeAllOtherThreads(thread);
        }
        HooksCmdResponse res = createInstance ? this.delegates.hooksApi().newInstance(thread.threadPtr(), classOrInstancePtr, methodInfo.name(), methodInfo.signature(), argsBuffer) : this.delegates.hooksApi().threadInvoke(thread.threadPtr(), classOrInstancePtr, methodInfo.name(), methodInfo.signature(), isStatic, returnType, argsBuffer);
        if (specReturnType == null) {
            output.writeByte((byte)86);
        } else if (specReturnType.isPrimitive()) {
            if (argsBuffer == null) {
                argsBuffer = new ByteBufferPacket(8, true);
                argsBuffer.setByteOrder(ByteOrder.LITTLE_ENDIAN);
            } else {
                argsBuffer.reset();
            }
            argsBuffer.writeLong((Long)res.result());
            ClassInfoPrimitiveImpl primitiveInfo = (ClassInfoPrimitiveImpl)callspec.returnType;
            argsBuffer.setPosition(0);
            Object value = primitiveInfo.manipulator().readFromDevice(argsBuffer);
            primitiveInfo.manipulator().writeToJdwp(output, value);
        } else {
            Object value = this.instanceByPointer((Long)res.result());
            this.manipulator.writeToJdwp(output, value);
        }
        if (res.exceptionPrt() == 0L) {
            output.writeByte((byte)76);
            output.writeLong(0L);
        } else {
            Object value = this.instanceByPointer(res.exceptionPrt());
            this.manipulator.writeToJdwp(output, value);
        }
    }

    ValueManipulator objectManipulator() {
        return this.manipulator;
    }

    private VmStringInstance createStringInstance(ClassInfo ci, long objectPtr, Object readValue) {
        VmStringInstance stringInstance = new VmStringInstance(objectPtr, ci);
        if (readValue != null && ((Boolean)readValue).booleanValue()) {
            this.readStringValue(stringInstance);
        }
        return stringInstance;
    }

    private VmThread createThreadInstance(ClassInfo ci, long objectPtr, Object threadPtr) {
        VmStringInstance nameInstance = (VmStringInstance)this.getFieldValue(objectPtr, ci, "name");
        String name = this.readStringValue(nameInstance);
        VmThreadGroup threadGroup = (VmThreadGroup)this.getFieldValue(objectPtr, ci, "group");
        return new VmThread(objectPtr, (Long)threadPtr, ci, name, threadGroup);
    }

    private VmThreadGroup createThreadGroupInstance(ClassInfo ci, long objectPtr, Object unused) {
        VmStringInstance nameInstance = (VmStringInstance)this.getFieldValue(objectPtr, ci, "name");
        String name = this.readStringValue(nameInstance);
        VmThreadGroup parent = (VmThreadGroup)this.getFieldValue(objectPtr, ci, "parent");
        return new VmThreadGroup(objectPtr, ci, name, parent);
    }

    private VmClassLoaderInstance createClassLoaderInstance(ClassInfo ci, long objectPtr, Object unused) {
        return new VmClassLoaderInstance(objectPtr, ci);
    }

    private VmClassInstance createClassInstance(ClassInfo ci, long objectPtr, Object unused) {
        ClassInfo representedClassInfo = this.runtimeClassInfoLoader.resolveRuntimeDataTypeInfo(objectPtr);
        return new VmClassInstance(objectPtr, ci, representedClassInfo);
    }

    private VmInstance createGenericInstance(ClassInfo ci, long objectPtr, Object unused) {
        return new VmInstance(objectPtr, ci);
    }

    private MethodInfo.CallSpec buildCallSpec(String signature) {
        if (!signature.startsWith("(")) {
            throw new DebuggerException("wrong method signature " + signature);
        }
        int div = signature.indexOf(41);
        if (div < 0) {
            throw new DebuggerException("wrong method signature " + signature);
        }
        String returnSignature = signature.substring(div + 1);
        String arguments = signature.substring(1, div);
        ClassInfo retType = null;
        char returnSignatureC = returnSignature.charAt(0);
        if (returnSignature.length() == 1) {
            if (returnSignatureC != 'V') {
                retType = this.classInfoLoader().getPrimitiveClassInfo(returnSignatureC);
            }
        } else if (returnSignatureC == 'L') {
            retType = ClassInfoImpl.EMPTY;
        } else if (returnSignatureC == '[') {
            retType = ClassInfoArrayImpl.EMPTY;
        } else {
            throw new DebuggerException("wrong method signature " + signature);
        }
        ArrayList<ClassInfo> argumentTypes = new ArrayList<ClassInfo>();
        if (arguments.length() != 0) {
            int[] pos = new int[]{0};
            while (pos[0] < arguments.length()) {
                char c = this.getNextParameterType(arguments, pos);
                if (c == 'L') {
                    argumentTypes.add(ClassInfoImpl.EMPTY);
                    continue;
                }
                if (c == '[') {
                    argumentTypes.add(ClassInfoArrayImpl.EMPTY);
                    continue;
                }
                argumentTypes.add(this.classInfoLoader().getPrimitiveClassInfo(c));
            }
        }
        return new MethodInfo.CallSpec(retType, argumentTypes.toArray(new ClassInfo[argumentTypes.size()]));
    }

    private char getNextParameterType(String signature, int[] pos) {
        char c = signature.charAt(pos[0]);
        pos[0] = pos[0] + 1;
        switch (c) {
            case 'B': 
            case 'C': 
            case 'D': 
            case 'F': 
            case 'I': 
            case 'J': 
            case 'S': 
            case 'Z': {
                return c;
            }
            case '[': {
                this.getNextParameterType(signature, pos);
                return c;
            }
            case 'L': {
                while (signature.charAt(pos[0]) != ';') {
                    pos[0] = pos[0] + 1;
                }
                pos[0] = pos[0] + 1;
                return c;
            }
        }
        throw new DebuggerException("wrong method signature " + signature);
    }

    private static class Manipulator
    extends ValueManipulator {
        private Manipulator(InstanceUtils utils) {
            super(fromDevice -> {
                long ptr = fromDevice.readPointer();
                return ptr != 0L ? utils.instanceByPointer(ptr) : null;
            }, fromJdwp -> {
                long refId = fromJdwp.readLong();
                return refId != 0L ? utils.delegates.state().referenceRefIdHolder().objectById(refId) : null;
            }, (writer, o) -> {
                VmInstance instance = (VmInstance)o;
                writer.writePointer(instance != null ? instance.objectPtr() : 0L);
            }, (jdwpWriter, o) -> {
                VmInstance instance = (VmInstance)o;
                if (instance != null) {
                    byte typeTag = Converter.jdwpInstanceTag(instance.classInfo(), utils.delegates.state().classInfoLoader());
                    jdwpWriter.writeByte(typeTag);
                    jdwpWriter.writeLong(instance.refId());
                } else {
                    jdwpWriter.writeByte((byte)76);
                    jdwpWriter.writeLong(0L);
                }
            }, (reader, length) -> {
                VmInstance[] arr = new VmInstance[length];
                for (int idx = 0; idx < length; ++idx) {
                    arr[idx] = utils.instanceByPointer(reader.readPointer());
                }
                return arr;
            });
        }
    }

    private static interface Instantiator {
        public VmInstance instance(ClassInfo var1, long var2, Object var4);
    }
}

