/*
 * Decompiled with CFR 0.152.
 */
package org.robovm.debugger.delegates;

import java.nio.ByteOrder;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.concurrent.LinkedBlockingQueue;
import org.robovm.debugger.DebuggerException;
import org.robovm.debugger.delegates.AllDelegates;
import org.robovm.debugger.delegates.RuntimeUtils;
import org.robovm.debugger.hooks.HookConsts;
import org.robovm.debugger.hooks.payloads.HooksCallStackEntry;
import org.robovm.debugger.hooks.payloads.HooksClassLoadedEventPayload;
import org.robovm.debugger.hooks.payloads.HooksEventPayload;
import org.robovm.debugger.hooks.payloads.HooksThreadEventPayload;
import org.robovm.debugger.hooks.payloads.HooksThreadStoppedEventPayload;
import org.robovm.debugger.jdwp.handlers.eventrequest.events.IJdwpEventDelegate;
import org.robovm.debugger.jdwp.handlers.eventrequest.events.JdwpClassLoadedEventData;
import org.robovm.debugger.jdwp.handlers.eventrequest.events.JdwpEventData;
import org.robovm.debugger.jdwp.handlers.eventrequest.events.JdwpEventRequest;
import org.robovm.debugger.jdwp.handlers.eventrequest.events.JdwpThreadStoppedEventData;
import org.robovm.debugger.jdwp.handlers.eventrequest.events.predicates.EventClassNameMatchPredicate;
import org.robovm.debugger.jdwp.handlers.eventrequest.events.predicates.EventClassTypeIdPredicate;
import org.robovm.debugger.jdwp.handlers.eventrequest.events.predicates.EventExceptionPredicate;
import org.robovm.debugger.jdwp.handlers.eventrequest.events.predicates.EventInstanceIdPredicate;
import org.robovm.debugger.jdwp.handlers.eventrequest.events.predicates.EventLocationPredicate;
import org.robovm.debugger.jdwp.handlers.eventrequest.events.predicates.EventModCountPredicate;
import org.robovm.debugger.jdwp.handlers.eventrequest.events.predicates.EventPredicate;
import org.robovm.debugger.jdwp.handlers.eventrequest.events.predicates.EventStepModPredicate;
import org.robovm.debugger.jdwp.handlers.eventrequest.events.predicates.EventThreadRefIdPredicate;
import org.robovm.debugger.state.classdata.ClassInfo;
import org.robovm.debugger.state.classdata.ClassInfoImpl;
import org.robovm.debugger.state.classdata.MethodInfo;
import org.robovm.debugger.state.instances.VmInstance;
import org.robovm.debugger.state.instances.VmStackTrace;
import org.robovm.debugger.state.instances.VmThread;
import org.robovm.debugger.utils.DbgLogger;
import org.robovm.debugger.utils.bytebuffer.ByteBufferPacket;

public class JdwpEventCenterDelegate
implements IJdwpEventDelegate {
    private DbgLogger log = DbgLogger.get(this.getClass().getSimpleName());
    private final AllDelegates delegates;
    private Set<Integer> requestIdsInTarget = new HashSet<Integer>();
    private Thread hooksEventsThread;
    private final ByteBufferPacket jdwpEventPayload;
    private LinkedBlockingQueue<HooksEventPayload> hooksEventsQueue = new LinkedBlockingQueue();
    private int jdwpEventRequestCounter = 100;
    private List<JdwpEventRequest> jdwpEventRequests = new ArrayList<JdwpEventRequest>();
    private boolean vmStartedNotified;
    private RuntimeUtils.RuntimeStepReference activeStepRequest;

    public JdwpEventCenterDelegate(AllDelegates delegates) {
        this.delegates = delegates;
        this.jdwpEventPayload = new ByteBufferPacket();
        this.jdwpEventPayload.setByteOrder(ByteOrder.BIG_ENDIAN);
    }

    public void onConnectedToTarget() {
        this.hooksEventsThread = this.delegates.toolBox().createThread(() -> this.processEventsCycle(), "EventCenterThread");
        this.hooksEventsThread.start();
    }

    public void onConnectedToJdpw() {
        if (this.delegates.hooksApi() != null) {
            this.notifyVmStarted();
        }
    }

    private void notifyVmStarted() {
        if (this.vmStartedNotified) {
            return;
        }
        this.vmStartedNotified = true;
        if (this.delegates.hooksApi() == null) {
            throw new DebuggerException("Hooks API is required to be set to resume VM");
        }
        this.delegates.threads().jdwpSuspendAllThreads();
        this.jdwpEventPayload.reset();
        JdwpEventData data = new JdwpEventData(90, null);
        data.dump(this.jdwpEventPayload, 0);
        this.delegates.jdwpServerApi().sendEvent((byte)2, 1, this.jdwpEventPayload);
    }

    public void postEventFromHooks(HooksEventPayload eventPayload) {
        this.hooksEventsQueue.add(eventPayload);
    }

    @Override
    public int jdwpSetEventRequest(byte eventKind, byte suspendPolicy, List<EventPredicate> predicates) {
        block8: for (EventPredicate predicate : predicates) {
            switch (predicate.modifierKind()) {
                case 4: {
                    long itemId = ((EventClassTypeIdPredicate)predicate).classTypeId();
                    if (this.delegates.state().classRefIdHolder().objectById(itemId) != null) break;
                    throw new DebuggerException(21);
                }
                case 8: {
                    long itemId = ((EventExceptionPredicate)predicate).refTypeId();
                    if (itemId == 0L || this.delegates.state().classRefIdHolder().objectById(itemId) != null) break;
                    throw new DebuggerException(21);
                }
                case 3: {
                    long itemId = ((EventThreadRefIdPredicate)predicate).threadRefId();
                    if (this.delegates.state().referenceRefIdHolder().instanceById(itemId) != null) break;
                    throw new DebuggerException(10);
                }
                case 11: {
                    long itemId = ((EventInstanceIdPredicate)predicate).instaceId();
                    if (this.delegates.state().referenceRefIdHolder().instanceById(itemId) != null) break;
                    throw new DebuggerException(20);
                }
                case 10: {
                    long itemId = ((EventStepModPredicate)predicate).threadId();
                    if (itemId == 0L) break;
                    VmThread thread = (VmThread)this.delegates.state().referenceRefIdHolder().instanceById(itemId);
                    if (thread != null) continue block8;
                    throw new DebuggerException(10);
                }
                case 7: {
                    EventLocationPredicate locationPredicate = (EventLocationPredicate)predicate;
                    if (this.delegates.state().classRefIdHolder().objectById(locationPredicate.classId()) == null) {
                        throw new DebuggerException(21);
                    }
                    MethodInfo methodInfo = this.delegates.state().methodsRefIdHolder().objectById(locationPredicate.methodId());
                    if (methodInfo == null) {
                        throw new DebuggerException(23);
                    }
                    if (methodInfo.debugInfo() == null || methodInfo.bpTableAddr() <= 0L) {
                        throw new DebuggerException(24);
                    }
                    if (locationPredicate.index() >= (long)methodInfo.debugInfo().startLine() && locationPredicate.index() <= (long)methodInfo.debugInfo().finalLine()) break;
                    throw new DebuggerException(24);
                }
            }
        }
        int requestId = this.allocateJdwpEventRequestId();
        JdwpEventRequest request = new JdwpEventRequest(requestId, eventKind, suspendPolicy, predicates);
        this.log.debug("jdwpSetEventRequest: " + request);
        this.jdwpEventRequests.add(request);
        this.applyRequestToTarget(request);
        return requestId;
    }

    @Override
    public short jdwpClearEventRequest(byte eventKind, int requestID) {
        Iterator<JdwpEventRequest> it = this.jdwpEventRequests.iterator();
        while (it.hasNext()) {
            JdwpEventRequest req = it.next();
            if (req.requestId() != requestID) continue;
            if (req.eventKind() != eventKind) {
                return 102;
            }
            it.remove();
            this.removeRequestFromTarget(req);
            return 0;
        }
        return 102;
    }

    @Override
    public void jdwpClearAllBreakpoints() {
        Iterator<JdwpEventRequest> it = this.jdwpEventRequests.iterator();
        while (it.hasNext()) {
            JdwpEventRequest req = it.next();
            if (req.eventKind() != 2) continue;
            this.removeRequestFromTarget(req);
            it.remove();
        }
    }

    @Override
    public void jdwpHoldEvents() {
    }

    @Override
    public void jdwpReleaseEvents() {
    }

    private void applyRequestToTarget(JdwpEventRequest request) {
        if (this.delegates.hooksApi() == null) {
            return;
        }
        if (this.requestIdsInTarget.contains(request.requestId())) {
            throw new DebuggerException("Request with id " + request.requestId() + " already registered with target");
        }
        switch (request.eventKind()) {
            case 2: {
                EventLocationPredicate location = (EventLocationPredicate)request.predicateByKind((byte)7);
                if (location == null) {
                    throw new DebuggerException(24);
                }
                MethodInfo methodInfo = this.delegates.state().methodsRefIdHolder().objectById(location.methodId());
                this.delegates.runtime().setBreakPoint(methodInfo, (int)location.index());
                break;
            }
            case 1: {
                EventStepModPredicate stepMod = (EventStepModPredicate)request.predicateByKind((byte)10);
                if (stepMod == null) {
                    throw new DebuggerException(102);
                }
                VmThread thread = (VmThread)this.delegates.state().referenceRefIdHolder().instanceById(stepMod.threadId());
                if (thread == null) {
                    throw new DebuggerException(10);
                }
                if (thread.suspendCount() == 0) {
                    throw new DebuggerException(13);
                }
                RuntimeUtils.RuntimeStepReference ref = this.delegates.runtime().step(thread, stepMod.depth());
                this.activeStepRequest = ref != null ? ref.setPayload(request) : null;
                break;
            }
            case 8: {
                if (request.suspendPolicy() != 2 && request.suspendPolicy() != 1) break;
                HashSet<String> classNamesToReport = null;
                for (EventPredicate p : request.predicates()) {
                    if (!(p instanceof EventClassNameMatchPredicate)) continue;
                    EventClassNameMatchPredicate predicate = (EventClassNameMatchPredicate)p;
                    if (classNamesToReport == null) {
                        classNamesToReport = new HashSet<String>(this.delegates.state().classInfoLoader().allClassNames());
                    }
                    String pattern = predicate.pattern().replace('.', '/');
                    boolean negative = predicate.isNegative();
                    if (predicate.isExact()) {
                        if (negative) {
                            classNamesToReport.remove(pattern);
                            continue;
                        }
                        boolean pass = classNamesToReport.contains(pattern);
                        classNamesToReport.clear();
                        if (!pass) continue;
                        classNamesToReport.add(pattern);
                        continue;
                    }
                    classNamesToReport.removeIf(v -> EventClassNameMatchPredicate.matchPattern(pattern, v) == negative);
                }
                if (classNamesToReport == null || classNamesToReport.isEmpty()) break;
                request.setFilteredClassNames((Set<String>)classNamesToReport);
                this.udpateActiveClassFilters();
                break;
            }
            default: {
                return;
            }
        }
        this.requestIdsInTarget.add(request.requestId());
    }

    private void removeRequestFromTarget(JdwpEventRequest request) {
        if (this.delegates.hooksApi() == null) {
            return;
        }
        if (!this.requestIdsInTarget.contains(request.requestId())) {
            return;
        }
        switch (request.eventKind()) {
            case 2: {
                EventLocationPredicate location = (EventLocationPredicate)request.predicateByKind((byte)7);
                if (location == null) {
                    throw new DebuggerException(24);
                }
                MethodInfo methodInfo = this.delegates.state().methodsRefIdHolder().objectById(location.methodId());
                this.delegates.runtime().clearBreakPoint(methodInfo, (int)location.index());
                break;
            }
            case 1: {
                if (this.activeStepRequest == null || request != this.activeStepRequest.payload()) break;
                this.activeStepRequest = null;
                break;
            }
            case 8: {
                if (request.filteredClassNames() == null || request.suspendPolicy() != 2 && request.suspendPolicy() != 1) break;
                this.udpateActiveClassFilters();
            }
        }
    }

    private void udpateActiveClassFilters() {
        HashSet<String> allClassesToFilter = new HashSet<String>();
        for (JdwpEventRequest r : this.jdwpEventRequests) {
            if (r.eventKind() != 8 || r.filteredClassNames() == null) continue;
            allClassesToFilter.addAll(r.filteredClassNames());
        }
        this.delegates.runtime().setClassLoadFilter(allClassesToFilter);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void processEventsCycle() {
        Object object = this.delegates.state().centralLock();
        synchronized (object) {
            if (this.delegates.jdwpServerApi() != null) {
                this.notifyVmStarted();
                for (JdwpEventRequest request : this.jdwpEventRequests) {
                    this.applyRequestToTarget(request);
                }
            }
        }
        while (!this.hooksEventsThread.isInterrupted()) {
            HooksEventPayload eventPayload;
            try {
                eventPayload = this.hooksEventsQueue.take();
            }
            catch (InterruptedException e) {
                return;
            }
            while (eventPayload != null) {
                Object object2 = this.delegates.state().centralLock();
                synchronized (object2) {
                    this.processSingleEvent(eventPayload);
                }
                eventPayload = this.hooksEventsQueue.poll();
            }
        }
    }

    private void processSingleEvent(HooksEventPayload eventPayload) {
        JdwpEventData eventData;
        VmThread stoppedThread = null;
        VmStackTrace[] stoppedThreadCallStack = null;
        switch (eventPayload.eventId()) {
            case 107: {
                HooksClassLoadedEventPayload classLoadEvent = (HooksClassLoadedEventPayload)eventPayload;
                if (classLoadEvent.threadObj() != 0L && classLoadEvent.callStack() != null) {
                    stoppedThread = this.getThread(classLoadEvent.eventId(), classLoadEvent.threadObj());
                    stoppedThreadCallStack = this.convertCallStack(classLoadEvent.eventId(), classLoadEvent.callStack());
                }
                eventData = this.processClassLoadedEvent(classLoadEvent);
                break;
            }
            case 100: 
            case 101: 
            case 102: 
            case 104: {
                eventData = this.processThreadEvent((HooksThreadEventPayload)eventPayload);
                break;
            }
            case 103: 
            case 105: 
            case 106: 
            case 108: {
                HooksThreadStoppedEventPayload stoppedEvent = (HooksThreadStoppedEventPayload)eventPayload;
                stoppedThread = this.getThread(stoppedEvent.eventId(), stoppedEvent.threadObj());
                stoppedThreadCallStack = this.convertCallStack(stoppedEvent.eventId(), stoppedEvent.callStack());
                if (eventPayload.eventId() == 103) {
                    this.delegates.threads().onThreadSuspended(stoppedThread, stoppedThreadCallStack, false);
                    eventData = null;
                    break;
                }
                eventData = this.processThreadStoppedEvent(stoppedEvent, stoppedThread, stoppedThreadCallStack);
                break;
            }
            default: {
                throw new DebuggerException("Unsupported Hooks object received " + eventPayload);
            }
        }
        if (eventData == null) {
            return;
        }
        int suspendPolicy = this.deliverEventToJdpwFiltered(eventData);
        if (suspendPolicy <= 0) {
            if (!(suspendPolicy >= 0 || eventPayload.eventId() != 106 && eventPayload.eventId() != 108 || stoppedThread == null || this.activeStepRequest == null || ((JdwpEventRequest)this.activeStepRequest.payload()).isCanceled() || this.activeStepRequest.thread().refId() != stoppedThread.refId() || stoppedThread.suspendCount() != 0)) {
                this.delegates.runtime().restep(this.activeStepRequest);
                this.delegates.threads().onThreadSuspended(stoppedThread, stoppedThreadCallStack, false);
                return;
            }
            if (stoppedThread != null) {
                this.delegates.threads().onThreadSuspended(stoppedThread, stoppedThreadCallStack, false);
            }
        } else if (stoppedThread != null) {
            this.delegates.threads().onThreadSuspended(stoppedThread, stoppedThreadCallStack, true);
            if (suspendPolicy == 2) {
                this.delegates.threads().suspendAllOtherThreads(stoppedThread);
            }
        }
    }

    private int deliverEventToJdpwFiltered(JdwpEventData eventData) {
        int processed = 0;
        byte suspendPolicy = 0;
        this.jdwpEventPayload.reset();
        if (this.delegates.jdwpServerApi() != null) {
            for (JdwpEventRequest request : this.jdwpEventRequests) {
                if (request.isCanceled() || eventData.eventKind() != request.eventKind()) continue;
                boolean testResult = request.test(eventData);
                EventModCountPredicate predicate = (EventModCountPredicate)request.predicateByKind((byte)1);
                if (predicate != null && predicate.modCount() < 0) {
                    request.setCanceled(true);
                }
                if (!testResult) continue;
                ++processed;
                if (request.suspendPolicy() > suspendPolicy) {
                    suspendPolicy = request.suspendPolicy();
                }
                eventData.dump(this.jdwpEventPayload, request.requestId());
            }
        }
        if (processed > 0) {
            this.delegates.jdwpServerApi().sendEvent(suspendPolicy, processed, this.jdwpEventPayload);
            return suspendPolicy;
        }
        return -1;
    }

    private JdwpEventData processClassLoadedEvent(HooksClassLoadedEventPayload event) {
        ClassInfo classInfo = this.delegates.state().classInfoLoader().onClassLoaded(this.delegates.runtime().toMachOAddr(event.classInfo()), event.clazz());
        if (!classInfo.isClass()) {
            throw new DebuggerException("Class load event for not class " + classInfo.signature());
        }
        VmThread thread = event.threadObj() != 0L ? this.getThread(event.eventId(), event.threadObj()) : null;
        return new JdwpClassLoadedEventData(8, thread, (ClassInfoImpl)classInfo);
    }

    private JdwpEventData processThreadEvent(HooksThreadEventPayload event) {
        VmThread thread = (VmThread)this.delegates.state().referenceRefIdHolder().instanceByAddr(event.threadObj());
        if (event.eventId() == 100 || event.eventId() == 101) {
            if (thread != null) {
                throw new DebuggerException("Thread " + Long.toHexString(event.threadObj()) + " already attached/started!");
            }
            thread = (VmThread)this.delegates.instances().instanceByPointer(event.threadObj(), event.thread(), true);
            this.delegates.state().threads().add(thread);
            this.log.debug("THREAD_STARTED: " + thread);
            return new JdwpEventData(6, thread);
        }
        if (thread == null) {
            throw new DebuggerException("Thread " + Long.toHexString(event.threadObj()) + " is not recognized!");
        }
        switch (event.eventId()) {
            case 104: {
                this.log.debug("THREAD_RESUMED: " + thread);
                thread.setStatus(VmThread.Status.RUNNING);
                return null;
            }
            case 102: {
                this.log.debug("THREAD_DETTACHED: " + thread);
                this.delegates.state().referenceRefIdHolder().removeObject(thread);
                this.delegates.state().threads().remove(thread);
                return new JdwpEventData(7, thread);
            }
        }
        throw new DebuggerException("Unsupported HooksThreadEventPayload eventId " + event.eventId());
    }

    private JdwpEventData processThreadStoppedEvent(HooksThreadStoppedEventPayload event, VmThread thread, VmStackTrace[] callStack) {
        VmStackTrace topTrace = callStack.length > 0 ? callStack[0] : null;
        switch (event.eventId()) {
            case 108: {
                ClassInfo ci = this.delegates.instances().classInfoLoader().resolveObjectRuntimeDataTypeInfo(event.throwable());
                VmInstance exception = new VmInstance(event.throwable(), ci);
                return new JdwpThreadStoppedEventData(4, thread, topTrace, exception, event.isCaught());
            }
            case 106: {
                return new JdwpThreadStoppedEventData(1, thread, topTrace);
            }
            case 105: {
                return new JdwpThreadStoppedEventData(2, thread, topTrace);
            }
        }
        throw new DebuggerException("Unsupported HooksThreadStoppedEventPayload eventId " + event.eventId());
    }

    private VmStackTrace[] convertCallStack(int eventId, HooksCallStackEntry[] callStack) {
        ArrayList<VmStackTrace> result = new ArrayList<VmStackTrace>();
        for (HooksCallStackEntry entry : callStack) {
            VmStackTrace stackTrace = this.convertStackTrace(eventId, entry);
            if (stackTrace == null) continue;
            result.add(stackTrace);
        }
        if (result.size() == 0) {
            this.log.error(HookConsts.commandToString(eventId) + ": Empty callstack!");
        }
        return result.toArray(new VmStackTrace[result.size()]);
    }

    private VmStackTrace convertStackTrace(int eventId, HooksCallStackEntry payload) {
        String signature = "L" + payload.clazzName() + ";";
        ClassInfo classInfo = this.delegates.state().classInfoLoader().classInfoBySignature(signature);
        if (classInfo == null) {
            this.log.error(HookConsts.commandToString(eventId) + ": Failed to get get stack entry. Class is not known " + payload.clazzName());
            return null;
        }
        MethodInfo[] methods = this.delegates.state().classInfoLoader().classMethods(classInfo);
        long implPtr = this.delegates.runtime().toMachOAddr(payload.impl());
        MethodInfo methodInfo = null;
        for (MethodInfo mi : methods) {
            if (mi.implPtr() != implPtr) continue;
            methodInfo = mi;
            break;
        }
        if (methodInfo == null) {
            this.log.error(HookConsts.commandToString(eventId) + ": Failed to get get stack entry. Method not found for impl " + Long.toHexString(payload.impl()) + " class " + payload.clazzName());
            return null;
        }
        return new VmStackTrace(classInfo, methodInfo, payload.lineNumber(), payload.fp());
    }

    private VmThread getThread(int eventId, long threadObj) {
        VmThread thread = (VmThread)this.delegates.state().referenceRefIdHolder().instanceByAddr(threadObj);
        if (thread == null) {
            throw new DebuggerException(HookConsts.commandToString(eventId) + ": Thread " + Long.toHexString(threadObj) + " is not recognized!");
        }
        return thread;
    }

    private int allocateJdwpEventRequestId() {
        return this.jdwpEventRequestCounter++;
    }
}

