/*
 * Decompiled with CFR 0.152.
 */
package org.robovm.debugger.delegates;

import org.robovm.debugger.DebuggerException;
import org.robovm.debugger.delegates.AllDelegates;
import org.robovm.debugger.jdwp.handlers.stackframe.IJdwpStackFrameDelegate;
import org.robovm.debugger.state.VmDebuggerState;
import org.robovm.debugger.state.classdata.ClassInfo;
import org.robovm.debugger.state.classdata.ClassInfoLoader;
import org.robovm.debugger.state.classdata.RuntimeClassInfoLoader;
import org.robovm.debugger.state.instances.VmStackTrace;
import org.robovm.debugger.state.instances.VmThread;
import org.robovm.debugger.utils.bytebuffer.ByteBufferPacket;
import org.robovm.llvm.debuginfo.DebugMethodInfo;
import org.robovm.llvm.debuginfo.DebugVariableInfo;

public class StackFrameDelegate
implements IJdwpStackFrameDelegate {
    private final AllDelegates delegates;

    public StackFrameDelegate(AllDelegates delegates) {
        this.delegates = delegates;
    }

    @Override
    public void getFrameValues(long threadId, long frameId, int[] varIndexes, byte[] varTags, ByteBufferPacket output) {
        VmDebuggerState state = this.delegates.state();
        VmThread thread = (VmThread)state.referenceRefIdHolder().instanceById(threadId);
        if (thread == null) {
            throw new DebuggerException(10);
        }
        VmStackTrace frame = state.frameRefIdHolder().objectById(frameId);
        if (frame == null) {
            throw new DebuggerException(30);
        }
        DebugMethodInfo debugInfo = frame.methodInfo().debugInfo();
        if (debugInfo == null) {
            throw new DebuggerException(113);
        }
        DebugVariableInfo[] variables = debugInfo.localvariables();
        ClassInfo[] classinfos = new ClassInfo[variables.length];
        int stackLineNumber = frame.lineNumber();
        RuntimeClassInfoLoader loader = this.delegates.instances().classInfoLoader();
        for (int idx : varIndexes) {
            if (idx >= variables.length || stackLineNumber < variables[idx].startLine() || stackLineNumber > variables[idx].finalLine()) {
                throw new DebuggerException(35);
            }
            classinfos[idx] = loader.loader().classInfoBySignature(variables[idx].typeSignature());
            if (classinfos[idx] != null || ClassInfoLoader.isArraySignature(variables[idx].typeSignature())) continue;
            if (ClassInfoLoader.isPrimitiveSignature(variables[idx].typeSignature())) {
                classinfos[idx] = loader.buildPrimitiveClassInfo(variables[idx].typeSignature());
            }
            if (classinfos[idx] != null && classinfos[idx].clazzPtr() != 0L) continue;
            throw new DebuggerException(22);
        }
        output.writeInt32(varIndexes.length);
        for (int idx : varIndexes) {
            long addr = this.getVariableAddress(frame, variables[idx]);
            this.delegates.instances().getMemoryValue(addr, classinfos[idx], output);
        }
    }

    @Override
    public void getFrameVariable(long threadId, long frameId, String variableName, ByteBufferPacket output) {
        VmDebuggerState state = this.delegates.state();
        VmThread thread = (VmThread)state.referenceRefIdHolder().instanceById(threadId);
        if (thread == null) {
            throw new DebuggerException(10);
        }
        VmStackTrace frame = state.frameRefIdHolder().objectById(frameId);
        if (frame == null) {
            throw new DebuggerException(30);
        }
        DebugMethodInfo debugInfo = frame.methodInfo().debugInfo();
        if (debugInfo == null) {
            throw new DebuggerException(113);
        }
        DebugVariableInfo[] variables = debugInfo.localvariables();
        DebugVariableInfo variable = null;
        int stackLineNumber = frame.lineNumber();
        for (DebugVariableInfo v : variables) {
            if (stackLineNumber < v.startLine() || stackLineNumber > v.finalLine() || !v.name().equals(variableName)) continue;
            variable = v;
            break;
        }
        if (variable != null) {
            ClassInfo ci = state.classInfoLoader().classInfoBySignature(variable.typeSignature());
            if (ci == null || ci.clazzPtr() == 0L) {
                throw new DebuggerException(22);
            }
            long addr = this.getVariableAddress(frame, variable);
            this.delegates.instances().getMemoryValue(addr, ci, output);
        } else {
            output.writeByte((byte)76);
            output.writeLong(0L);
        }
    }

    @Override
    public void setFrameValues(long threadId, long frameId, ByteBufferPacket fromJdpw, int count) {
        VmDebuggerState state = this.delegates.state();
        VmThread thread = (VmThread)state.referenceRefIdHolder().instanceById(threadId);
        if (thread == null) {
            throw new DebuggerException(10);
        }
        VmStackTrace frame = state.frameRefIdHolder().objectById(frameId);
        if (frame == null) {
            throw new DebuggerException(30);
        }
        DebugMethodInfo debugInfo = frame.methodInfo().debugInfo();
        if (debugInfo == null) {
            throw new DebuggerException(113);
        }
        DebugVariableInfo[] variables = debugInfo.localvariables();
        int stackLineNumber = frame.lineNumber();
        RuntimeClassInfoLoader loader = this.delegates.instances().classInfoLoader();
        while (count > 0) {
            --count;
            int idx = fromJdpw.readInt32();
            if (idx >= variables.length || stackLineNumber < variables[idx].startLine() || stackLineNumber > variables[idx].finalLine()) {
                throw new DebuggerException(35);
            }
            ClassInfo ci = loader.loader().classInfoBySignature(variables[idx].typeSignature());
            if (ci == null && !ClassInfoLoader.isArraySignature(variables[idx].typeSignature())) {
                if (ClassInfoLoader.isPrimitiveSignature(variables[idx].typeSignature())) {
                    ci = loader.buildPrimitiveClassInfo(variables[idx].typeSignature());
                }
                if (ci == null || ci.clazzPtr() == 0L) {
                    throw new DebuggerException(22);
                }
            }
            long addr = this.getVariableAddress(frame, variables[idx]);
            byte tag = fromJdpw.readByte();
            this.delegates.instances().setMemoryValue(addr, ci, null, fromJdpw);
        }
    }

    private long getVariableAddress(VmStackTrace frame, DebugVariableInfo variableInfo) {
        long addr;
        if (variableInfo.register() == 145) {
            addr = frame.fp() + (long)variableInfo.offset();
        } else if (variableInfo.register() == 143 || variableInfo.register() == 125) {
            addr = frame.fp() - (long)frame.methodInfo().spFpOffset() & (long)(~(frame.methodInfo().spFpAlign() - 1));
            addr += (long)variableInfo.offset();
        } else {
            throw new DebuggerException("Unexpected register for stack trace variable " + DebugVariableInfo.registerName((int)variableInfo.register()));
        }
        return addr;
    }
}

