/*
 * Decompiled with CFR 0.152.
 */
package org.robovm.debugger.jdwp.handlers.classtype;

import org.robovm.debugger.DebuggerException;
import org.robovm.debugger.jdwp.handlers.objectreference.IJdwpInstanceDelegate;
import org.robovm.debugger.jdwp.protocol.IJdwpRequestHandler;
import org.robovm.debugger.utils.bytebuffer.ByteBufferPacket;

public class JdwpClassTypeInvokeMethodHandler
implements IJdwpRequestHandler {
    private final IJdwpInstanceDelegate delegate;

    public JdwpClassTypeInvokeMethodHandler(IJdwpInstanceDelegate delegate) {
        this.delegate = delegate;
    }

    @Override
    public short handle(ByteBufferPacket payload, ByteBufferPacket output) {
        long classId = payload.readLong();
        long threadId = payload.readLong();
        long methodId = payload.readLong();
        int argCount = payload.readInt32();
        byte[] tags = new byte[argCount];
        Object[] args = new Object[argCount];
        try {
            JdwpClassTypeInvokeMethodHandler.readTaggedArguments(tags, args, payload);
            int invokeOptions = payload.readInt32();
            boolean singleThread = (invokeOptions & 1) != 0;
            this.delegate.jdwpInvokeMethod(classId, threadId, methodId, true, singleThread, args, output);
        }
        catch (ClassCastException e) {
            return 20;
        }
        catch (DebuggerException e) {
            if (e.getCode() < 0) {
                throw e;
            }
            return (short)e.getCode();
        }
        return 0;
    }

    @Override
    public byte getCommandSet() {
        return 3;
    }

    @Override
    public byte getCommand() {
        return 3;
    }

    public String toString() {
        return "ClassType(3).InvokeMethod(3)";
    }

    public static void readTaggedArguments(byte[] tags, Object[] args, ByteBufferPacket payload) {
        for (int idx = 0; idx < args.length; ++idx) {
            Comparable<Boolean> v;
            byte tag = payload.readByte();
            switch (tag) {
                case 90: {
                    v = payload.readBoolean();
                    break;
                }
                case 66: {
                    v = payload.readByte();
                    break;
                }
                case 67: {
                    v = Character.valueOf(payload.readChar16());
                    break;
                }
                case 83: {
                    v = payload.readInt16();
                    break;
                }
                case 73: {
                    v = payload.readInt32();
                    break;
                }
                case 74: {
                    v = payload.readLong();
                    break;
                }
                case 70: {
                    v = Float.valueOf(payload.readFloat());
                    break;
                }
                case 68: {
                    v = payload.readDouble();
                    break;
                }
                case 76: 
                case 91: 
                case 99: 
                case 103: 
                case 108: 
                case 115: 
                case 116: {
                    v = payload.readLong();
                    break;
                }
                default: {
                    throw new DebuggerException(500);
                }
            }
            tags[idx] = tag;
            args[idx] = v;
        }
    }
}

