/*
 * Decompiled with CFR 0.152.
 */
package org.robovm.debugger.jdwp.handlers.eventrequest.events;

import org.robovm.debugger.jdwp.handlers.eventrequest.events.JdwpEventData;
import org.robovm.debugger.state.classdata.ClassInfoImpl;
import org.robovm.debugger.state.instances.VmThread;
import org.robovm.debugger.utils.Converter;
import org.robovm.debugger.utils.bytebuffer.ByteBufferPacket;

public class JdwpClassLoadedEventData
extends JdwpEventData {
    private final ClassInfoImpl classInfo;
    private final String className;

    public JdwpClassLoadedEventData(byte eventKind, VmThread thread, ClassInfoImpl classInfo) {
        super(eventKind, thread);
        this.classInfo = classInfo;
        this.className = this.makeClassName(classInfo);
    }

    @Override
    public String getClassName() {
        return this.className;
    }

    @Override
    protected void dumpCustomData(ByteBufferPacket packet) {
        packet.writeByte(Converter.jdwpTypeTag(this.classInfo));
        packet.writeLong(this.classInfo.refId());
        packet.writeStringWithLen(this.classInfo.signature());
        packet.writeInt32(Converter.jdwpClassStatus(this.classInfo));
    }

    @Override
    public boolean cancelIfNotHandled() {
        return this.thread() != null;
    }
}

