/*
 * Decompiled with CFR 0.152.
 */
package org.robovm.debugger.jdwp.handlers.method;

import org.robovm.debugger.jdwp.protocol.IJdwpRequestHandler;
import org.robovm.debugger.state.VmDebuggerState;
import org.robovm.debugger.state.classdata.MethodInfo;
import org.robovm.debugger.utils.bytebuffer.ByteBufferPacket;
import org.robovm.llvm.debuginfo.DebugMethodInfo;

public class JdwpMethodLineTableHandler
implements IJdwpRequestHandler {
    private final VmDebuggerState state;

    public JdwpMethodLineTableHandler(VmDebuggerState state) {
        this.state = state;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public short handle(ByteBufferPacket payload, ByteBufferPacket output) {
        long refTypeId = payload.readLong();
        long methodId = payload.readLong();
        Object object = this.state.centralLock();
        synchronized (object) {
            MethodInfo methodInfo = this.state.methodsRefIdHolder().objectById(methodId);
            if (methodInfo == null) {
                return 23;
            }
            DebugMethodInfo debugInfo = methodInfo.debugInfo();
            if (debugInfo == null) {
                return 101;
            }
            int startLine = debugInfo.startLine();
            int finalLine = debugInfo.finalLine();
            output.writeLong(startLine);
            output.writeLong(finalLine);
            output.writeInt32(finalLine - startLine + 1);
            for (int lineNo = startLine; lineNo <= finalLine; ++lineNo) {
                output.writeLong(lineNo);
                output.writeInt32(lineNo);
            }
            return 0;
        }
    }

    @Override
    public byte getCommandSet() {
        return 6;
    }

    @Override
    public byte getCommand() {
        return 1;
    }

    public String toString() {
        return "Method(6).LineTable(1)";
    }
}

