/*
 * Decompiled with CFR 0.152.
 */
package org.robovm.debugger.jdwp.handlers.referencetype;

import org.robovm.debugger.jdwp.protocol.IJdwpRequestHandler;
import org.robovm.debugger.state.VmDebuggerState;
import org.robovm.debugger.state.classdata.ClassInfo;
import org.robovm.debugger.state.classdata.FieldInfo;
import org.robovm.debugger.utils.bytebuffer.ByteBufferPacket;

public class JdwpRefTypeFieldsHandler
implements IJdwpRequestHandler {
    private final VmDebuggerState state;

    public JdwpRefTypeFieldsHandler(VmDebuggerState state) {
        this.state = state;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public short handle(ByteBufferPacket payload, ByteBufferPacket output) {
        long referenceTypeID = payload.readLong();
        Object object = this.state.centralLock();
        synchronized (object) {
            ClassInfo classInfo = this.state.classInfoLoader().classInfoByRefId(referenceTypeID);
            if (classInfo == null) {
                return 20;
            }
            FieldInfo[] fields2 = this.state.classInfoLoader().classFields(classInfo);
            output.writeInt32(fields2.length);
            for (FieldInfo fieldInfo : fields2) {
                output.writeLong(fieldInfo.refId());
                output.writeStringWithLen(fieldInfo.name());
                output.writeStringWithLen(fieldInfo.signature());
                String signatureWithGeneric = this.getGenericSignature();
                if (signatureWithGeneric != null) {
                    output.writeStringWithLen(signatureWithGeneric);
                }
                output.writeInt32(fieldInfo.modifiers());
            }
        }
        return 0;
    }

    protected String getGenericSignature() {
        return null;
    }

    @Override
    public byte getCommandSet() {
        return 2;
    }

    @Override
    public byte getCommand() {
        return 4;
    }

    public String toString() {
        return "ReferenceType(2).Fields(4)";
    }
}

