/*
 * Decompiled with CFR 0.152.
 */
package org.robovm.debugger.jdwp.handlers.referencetype;

import org.robovm.debugger.jdwp.protocol.IJdwpRequestHandler;
import org.robovm.debugger.state.VmDebuggerState;
import org.robovm.debugger.state.classdata.ClassInfo;
import org.robovm.debugger.utils.bytebuffer.ByteBufferPacket;

public class JdwpRefTypeSignatureHandler
implements IJdwpRequestHandler {
    private final VmDebuggerState state;

    public JdwpRefTypeSignatureHandler(VmDebuggerState state) {
        this.state = state;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public short handle(ByteBufferPacket payload, ByteBufferPacket output) {
        long referenceTypeID = payload.readLong();
        Object object = this.state.centralLock();
        synchronized (object) {
            ClassInfo classInfo = this.state.classInfoLoader().classInfoByRefId(referenceTypeID);
            if (classInfo == null) {
                return 21;
            }
            output.writeStringWithLen(classInfo.signature());
            String signatureWithGeneric = this.getGenericSignature();
            if (signatureWithGeneric != null) {
                output.writeStringWithLen(signatureWithGeneric);
            }
        }
        return 0;
    }

    protected String getGenericSignature() {
        return null;
    }

    @Override
    public byte getCommandSet() {
        return 2;
    }

    @Override
    public byte getCommand() {
        return 1;
    }

    public String toString() {
        return "ReferenceType(2).Signature(1)";
    }
}

