/*
 * Decompiled with CFR 0.152.
 */
package org.robovm.debugger.jdwp.handlers.referencetype;

import org.robovm.debugger.jdwp.protocol.IJdwpRequestHandler;
import org.robovm.debugger.state.VmDebuggerState;
import org.robovm.debugger.state.classdata.ClassInfo;
import org.robovm.debugger.utils.Converter;
import org.robovm.debugger.utils.bytebuffer.ByteBufferPacket;

public class JdwpRefTypeStatusHandler
implements IJdwpRequestHandler {
    private final VmDebuggerState state;

    public JdwpRefTypeStatusHandler(VmDebuggerState state) {
        this.state = state;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public short handle(ByteBufferPacket payload, ByteBufferPacket output) {
        long refTypeId = payload.readLong();
        Object object = this.state.centralLock();
        synchronized (object) {
            ClassInfo ci = this.state.classRefIdHolder().objectById(refTypeId);
            if (ci == null) {
                return 20;
            }
            output.writeInt32(Converter.jdwpClassStatus(ci));
        }
        return 0;
    }

    @Override
    public byte getCommandSet() {
        return 2;
    }

    @Override
    public byte getCommand() {
        return 9;
    }

    public String toString() {
        return "ReferenceType(2).Status(9)";
    }
}

