/*
 * Decompiled with CFR 0.152.
 */
package org.robovm.debugger.jdwp.handlers.stackframe;

import org.robovm.debugger.DebuggerException;
import org.robovm.debugger.jdwp.handlers.stackframe.IJdwpStackFrameDelegate;
import org.robovm.debugger.jdwp.protocol.IJdwpRequestHandler;
import org.robovm.debugger.utils.bytebuffer.ByteBufferPacket;

public class JdwpStackFrameGetValuesHandler
implements IJdwpRequestHandler {
    private final IJdwpStackFrameDelegate delegate;

    public JdwpStackFrameGetValuesHandler(IJdwpStackFrameDelegate delegate) {
        this.delegate = delegate;
    }

    @Override
    public short handle(ByteBufferPacket payload, ByteBufferPacket output) {
        long threadId = payload.readLong();
        long frameId = payload.readLong();
        int slots = payload.readInt32();
        int[] varIndexes = new int[slots];
        byte[] varTags = new byte[slots];
        for (int idx = 0; idx < slots; ++idx) {
            varIndexes[idx] = payload.readInt32();
            varTags[idx] = payload.readByte();
        }
        try {
            this.delegate.getFrameValues(threadId, frameId, varIndexes, varTags, output);
        }
        catch (ClassCastException e) {
            return 20;
        }
        catch (DebuggerException e) {
            if (e.getCode() < 0) {
                throw e;
            }
            return (short)e.getCode();
        }
        return 0;
    }

    @Override
    public byte getCommandSet() {
        return 16;
    }

    @Override
    public byte getCommand() {
        return 1;
    }

    public String toString() {
        return "StackFrame(16).GetValues(1)";
    }
}

