/*
 * Decompiled with CFR 0.152.
 */
package org.robovm.debugger.jdwp.handlers.thread;

import org.robovm.debugger.jdwp.protocol.IJdwpRequestHandler;
import org.robovm.debugger.state.VmDebuggerState;
import org.robovm.debugger.state.instances.VmStackTrace;
import org.robovm.debugger.state.instances.VmThread;
import org.robovm.debugger.utils.Converter;
import org.robovm.debugger.utils.bytebuffer.ByteBufferPacket;

public class JdwpThreadFramesHandler
implements IJdwpRequestHandler {
    private final VmDebuggerState state;

    public JdwpThreadFramesHandler(VmDebuggerState state) {
        this.state = state;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public short handle(ByteBufferPacket payload, ByteBufferPacket output) {
        long threadId = payload.readLong();
        int startFrame = payload.readInt32();
        int length = payload.readInt32();
        Object object = this.state.centralLock();
        synchronized (object) {
            VmThread thread;
            try {
                thread = (VmThread)this.state.referenceRefIdHolder().instanceById(threadId);
            }
            catch (ClassCastException e) {
                return 10;
            }
            if (thread == null) {
                return 10;
            }
            if (thread.suspendCount() == 0) {
                return 13;
            }
            VmStackTrace[] stack = thread.stack();
            int lastFrame = -1;
            if (stack != null) {
                int n = lastFrame = length < 0 ? stack.length - 1 : startFrame + length - 1;
            }
            if (stack == null || startFrame > stack.length - 1 || lastFrame > stack.length - 1 || startFrame > lastFrame) {
                output.writeInt32(0);
            } else {
                output.writeInt32(lastFrame - startFrame + 1);
                for (int i = startFrame; i <= lastFrame; ++i) {
                    VmStackTrace frame = stack[i];
                    output.writeLong(frame.refId());
                    output.writeByte(Converter.jdwpTypeTag(frame.classInfo()));
                    output.writeLong(frame.classInfo().refId());
                    output.writeLong(frame.methodInfo().refId());
                    output.writeLong(frame.lineNumber());
                }
            }
        }
        return 0;
    }

    @Override
    public byte getCommandSet() {
        return 11;
    }

    @Override
    public byte getCommand() {
        return 6;
    }

    public String toString() {
        return "ThreadReference(11).Frames(6)";
    }
}

