/*
 * Decompiled with CFR 0.152.
 */
package org.robovm.debugger.runtime;

import org.robovm.debugger.DebuggerException;
import org.robovm.debugger.utils.bytebuffer.ByteBufferPacket;
import org.robovm.debugger.utils.bytebuffer.ByteBufferReader;

public class ValueManipulator {
    private final Reader fromDevice;
    private final Reader fromJdwp;
    private final Writer toDevice;
    private final Writer toJdwp;
    private final ArrayReader fromDeviceArray;
    public static ValueManipulator Boolean = new ValueManipulator(ByteBufferReader::readBoolean, (writer, o) -> writer.writeBoolean((Boolean)o), (jdwpWriter, o) -> {
        jdwpWriter.writeByte((byte)90);
        jdwpWriter.writeBoolean((Boolean)o);
    }, (reader, length) -> {
        boolean[] arr = new boolean[length];
        for (int idx = 0; idx < length; ++idx) {
            arr[idx] = reader.readBoolean();
        }
        return arr;
    });
    public static ValueManipulator Byte = new ValueManipulator(ByteBufferReader::readByte, (writer, o) -> writer.writeByte((Byte)o), (jdwpWriter, o) -> {
        jdwpWriter.writeByte((byte)66);
        jdwpWriter.writeByte((Byte)o);
    }, (reader, length) -> {
        byte[] arr = new byte[length];
        for (int idx = 0; idx < length; ++idx) {
            arr[idx] = reader.readByte();
        }
        return arr;
    });
    public static ValueManipulator Character = new ValueManipulator(ByteBufferReader::readChar16, (writer, o) -> writer.writeChar16(((Character)o).charValue()), (jdwpWriter, o) -> {
        jdwpWriter.writeByte((byte)67);
        jdwpWriter.writeChar16(((Character)o).charValue());
    }, (reader, length) -> {
        char[] arr = new char[length];
        for (int idx = 0; idx < length; ++idx) {
            arr[idx] = reader.readChar16();
        }
        return arr;
    });
    public static ValueManipulator Short = new ValueManipulator(ByteBufferReader::readInt16, (writer, o) -> writer.writeInt16((Short)o), (jdwpWriter, o) -> {
        jdwpWriter.writeByte((byte)83);
        jdwpWriter.writeInt16((Short)o);
    }, (reader, length) -> {
        short[] arr = new short[length];
        for (int idx = 0; idx < length; ++idx) {
            arr[idx] = reader.readInt16();
        }
        return arr;
    });
    public static ValueManipulator Integer = new ValueManipulator(ByteBufferReader::readInt32, (writer, o) -> writer.writeInt32((Integer)o), (jdwpWriter, o) -> {
        jdwpWriter.writeByte((byte)73);
        jdwpWriter.writeInt32((Integer)o);
    }, (reader, length) -> {
        int[] arr = new int[length];
        for (int idx = 0; idx < length; ++idx) {
            arr[idx] = reader.readInt32();
        }
        return arr;
    });
    public static ValueManipulator Long = new ValueManipulator(ByteBufferReader::readLong, (writer, o) -> writer.writeLong((Long)o), (jdwpWriter, o) -> {
        jdwpWriter.writeByte((byte)74);
        jdwpWriter.writeLong((Long)o);
    }, (reader, length) -> {
        long[] arr = new long[length];
        for (int idx = 0; idx < length; ++idx) {
            arr[idx] = reader.readLong();
        }
        return arr;
    });
    public static ValueManipulator Float = new ValueManipulator(ByteBufferReader::readFloat, (writer, o) -> writer.writeFloat(((Float)o).floatValue()), (jdwpWriter, o) -> {
        jdwpWriter.writeByte((byte)70);
        jdwpWriter.writeFloat(((Float)o).floatValue());
    }, (reader, length) -> {
        float[] arr = new float[length];
        for (int idx = 0; idx < length; ++idx) {
            arr[idx] = reader.readFloat();
        }
        return arr;
    });
    public static ValueManipulator Double = new ValueManipulator(ByteBufferReader::readDouble, (writer, o) -> writer.writeDouble((Double)o), (jdwpWriter, o) -> {
        jdwpWriter.writeByte((byte)68);
        jdwpWriter.writeDouble((Double)o);
    }, (reader, length) -> {
        double[] arr = new double[length];
        for (int idx = 0; idx < length; ++idx) {
            arr[idx] = reader.readDouble();
        }
        return arr;
    });
    public static ValueManipulator Void = new ValueManipulator(reader -> {
        throw new DebuggerException("invalid access for type VOID");
    }, (writer, o) -> {
        throw new DebuggerException("invalid access for type VOID");
    }, (reader, length) -> {
        throw new DebuggerException("invalid access for type VOID");
    });

    protected ValueManipulator(Reader fromDevice, Reader fromJdwp, Writer toDevice, Writer toJdwp, ArrayReader fromDeviceArray) {
        this.fromDevice = fromDevice;
        this.fromJdwp = fromJdwp;
        this.toDevice = toDevice;
        this.toJdwp = toJdwp;
        this.fromDeviceArray = fromDeviceArray;
    }

    protected ValueManipulator(Reader reader, Writer writer, ArrayReader fromDeviceArray) {
        this.fromDevice = reader;
        this.fromJdwp = reader;
        this.toDevice = writer;
        this.toJdwp = writer;
        this.fromDeviceArray = fromDeviceArray;
    }

    protected ValueManipulator(Reader reader, Writer writer, Writer jdwpWriter, ArrayReader fromDeviceArray) {
        this.fromDevice = reader;
        this.fromJdwp = reader;
        this.toDevice = writer;
        this.toJdwp = jdwpWriter;
        this.fromDeviceArray = fromDeviceArray;
    }

    public Object readFromDevice(ByteBufferReader reader) {
        return this.fromDevice.read(reader);
    }

    public <T> T readArrayFromDevice(ByteBufferReader reader, int length) {
        return (T)this.fromDeviceArray.read(reader, length);
    }

    public Object readFromJdwp(ByteBufferReader reader) {
        return this.fromJdwp.read(reader);
    }

    public void writeToDevice(ByteBufferPacket writer, Object o) {
        this.toDevice.write(writer, o);
    }

    public void writeToJdwp(ByteBufferPacket writer, Object o) {
        this.toJdwp.write(writer, o);
    }

    protected static interface ArrayReader {
        public Object read(ByteBufferReader var1, int var2);
    }

    protected static interface Writer {
        public void write(ByteBufferPacket var1, Object var2);
    }

    protected static interface Reader {
        public Object read(ByteBufferReader var1);
    }
}

