/*
 * Decompiled with CFR 0.152.
 */
package org.robovm.debugger.state.classdata;

import java.nio.ByteBuffer;
import org.robovm.compiler.plugin.debug.DebugInformationTools;
import org.robovm.debugger.DebuggerException;
import org.robovm.debugger.state.classdata.ClassInfo;
import org.robovm.debugger.state.classdata.ClassInfoEmptyImpl;
import org.robovm.debugger.state.classdata.ClassInfoLoader;
import org.robovm.debugger.state.classdata.FieldInfo;
import org.robovm.debugger.state.classdata.MethodInfo;
import org.robovm.debugger.state.refid.RefIdHolder;
import org.robovm.debugger.utils.Converter;
import org.robovm.debugger.utils.bytebuffer.ByteBufferMemoryReader;
import org.robovm.llvm.debuginfo.DebugMethodInfo;
import org.robovm.llvm.debuginfo.DebugObjectFileInfo;

public class ClassInfoImpl
extends ClassInfo {
    public static ClassInfo EMPTY = new ClassInfoEmptyImpl(ClassInfo.Type.CLASS);
    private int flags;
    private String className;
    private String signature;
    private String superclassName;
    private String superclassSignature;
    private ClassInfo[] interfaces;
    private FieldInfo[] fields;
    private MethodInfo[] methods;
    private DebugObjectFileInfo debugInfo;
    private long endOfHeaderPos;

    public ClassInfoImpl() {
        super(ClassInfo.Type.CLASS);
    }

    void readClassInfoHeader(ByteBufferMemoryReader reader) {
        int pointerSize = reader.pointerSize();
        long clazzPtr = reader.readPointer();
        this.flags = reader.readInt32();
        long ptr = reader.readPointer(true);
        this.className = reader.readStringZAtPtr(ptr);
        this.signature = "L" + this.className + ";";
        if (this.hasError()) {
            return;
        }
        reader.skip(pointerSize + pointerSize + pointerSize + pointerSize + 4 + 4 + 4 + 2 + 2);
        this.endOfHeaderPos = reader.address();
        if (!this.isInterface()) {
            reader.skip(6);
            long superNamePtr = reader.readPointer();
            if (superNamePtr != 0L) {
                this.superclassName = reader.readStringZAtPtr(superNamePtr);
                this.superclassSignature = "L" + this.superclassName + ";";
            }
        }
    }

    void loadData(ClassInfoLoader loader) {
        if (this.hasError()) {
            return;
        }
        if (this.endOfHeaderPos == 0L) {
            return;
        }
        this.debugInfo = this.readDebugInfo(loader);
        ByteBufferMemoryReader reader = loader.reader;
        reader.setAddress(this.endOfHeaderPos);
        int interfaceCount = reader.readInt16();
        short fieldCount = reader.readInt16();
        short methodCount = reader.readInt16();
        if (!this.isInterface()) {
            reader.skip(reader.pointerSize());
        }
        if ((this.flags & 0x80) != 0) {
            reader.skip(reader.pointerSize());
        }
        this.interfaces = new ClassInfo[interfaceCount];
        for (int idx = 0; idx < interfaceCount; ++idx) {
            long ptr = reader.readPointer();
            String interfaceSignature = "L" + reader.readStringZAtPtr(ptr) + ";";
            this.interfaces[idx] = loader.classInfoBySignature(interfaceSignature);
            if (this.interfaces[idx] != null) continue;
            throw new DebuggerException("Interface '" + interfaceSignature + "' not found in " + this.className);
        }
        this.readFields(reader, fieldCount, loader.fieldRefIdHolder);
        this.readMethods(reader, methodCount, loader);
        this.endOfHeaderPos = 0L;
    }

    private DebugObjectFileInfo readDebugInfo(ClassInfoLoader loader) {
        String debugInfoSymbol = "[j]" + this.className.replace('/', '.') + "[debuginfo]";
        long addr = loader.appFileLoader.resolveSymbol(debugInfoSymbol);
        if (addr < 0L) {
            return null;
        }
        loader.reader.setAddress(addr);
        ByteBuffer buffer = loader.reader.sliceToByteBuffer();
        return DebugInformationTools.readDebugInfo((ByteBuffer)buffer);
    }

    private void readFields(ByteBufferMemoryReader reader, int fieldCount, RefIdHolder<FieldInfo> fieldRefIdHolder) {
        this.fields = new FieldInfo[fieldCount];
        for (int idx = 0; idx < fieldCount; ++idx) {
            this.fields[idx] = new FieldInfo();
            this.fields[idx].readFieldInfo(reader);
            fieldRefIdHolder.addObject(this.fields[idx]);
        }
    }

    private void readMethods(ByteBufferMemoryReader reader, int methodCount, ClassInfoLoader loader) {
        RefIdHolder<MethodInfo> methodsRefIdHolder = loader.methodsRefIdHolder;
        this.methods = new MethodInfo[methodCount];
        for (int idx = 0; idx < methodCount; ++idx) {
            MethodInfo methodInfo;
            this.methods[idx] = methodInfo = new MethodInfo();
            methodInfo.readMethodInfo(reader);
            if (methodInfo.isBridge() || methodInfo.isBroCallback() || methodInfo.isBroCallback() || methodInfo.isBroBridge()) {
                methodInfo.markAsNative();
            }
            if (!methodInfo.isNative()) {
                DebugMethodInfo methodDebugInfo = null;
                long bpTableAddr = -1L;
                int spFpOffset = -1;
                int spFpAlign = -1;
                if (this.debugInfo != null) {
                    methodDebugInfo = this.debugInfo.methodBySignature(methodInfo.name() + methodInfo.signature());
                    if (methodDebugInfo != null) {
                        String bpTableSymbol = "[j]" + this.className.replace('/', '.') + "." + methodInfo.name() + methodInfo.signature() + "[bptable]";
                        bpTableAddr = loader.appFileLoader.resolveSymbol(bpTableSymbol);
                    }
                    if (methodDebugInfo != null && (loader.appFileLoader.cpuType() == 0x100000C || loader.appFileLoader.cpuType() == 12)) {
                        String spFpOffsetSymbol = "[J]" + this.className.replace('/', '.') + "." + methodInfo.name() + methodInfo.signature() + ".spfpoffset";
                        long spFpOffsetAddr = loader.appFileLoader.resolveSymbol(spFpOffsetSymbol);
                        if (spFpOffsetAddr != -1L) {
                            long oldAddr = reader.address();
                            reader.setAddress(spFpOffsetAddr);
                            int spFpOffsetValue = reader.readInt32();
                            reader.setAddress(oldAddr);
                            spFpOffset = (spFpOffsetValue & 0xFFFFFFF) << 2;
                            spFpAlign = (spFpOffsetValue >> 28) + 1 << 2;
                        }
                    } else {
                        spFpOffset = 0;
                        spFpAlign = 0;
                    }
                }
                if (methodDebugInfo != null && spFpAlign != -1) {
                    methodInfo.setDebugInfo(methodDebugInfo, spFpOffset, spFpAlign);
                    methodInfo.setBpTableAddr(bpTableAddr);
                } else {
                    methodInfo.markAsNative();
                }
            }
            methodsRefIdHolder.addObject(methodInfo);
        }
    }

    public String className() {
        return this.className;
    }

    public String superclassName() {
        return this.superclassName;
    }

    @Override
    public String superclassSignature() {
        return this.superclassSignature;
    }

    @Override
    public String signature() {
        return this.signature;
    }

    @Override
    public FieldInfo[] fields(ClassInfoLoader loader) {
        this.loadData(loader);
        return this.fields;
    }

    @Override
    public MethodInfo[] methods(ClassInfoLoader loader) {
        this.loadData(loader);
        return this.methods;
    }

    @Override
    public ClassInfo[] interfaces(ClassInfoLoader loader) {
        this.loadData(loader);
        return this.interfaces;
    }

    @Override
    public boolean hasError() {
        return (this.flags & 0x100) != 0;
    }

    @Override
    protected int convertModifiers() {
        return Converter.classModifiers(this.flags);
    }

    public String sourceFile() {
        String sourceFile;
        if (this.debugInfo != null) {
            sourceFile = this.debugInfo.sourceFile();
        } else {
            sourceFile = this.className();
            int sepIdx = sourceFile.lastIndexOf(47);
            if (sepIdx > 0) {
                sourceFile = sourceFile.substring(sepIdx + 1);
            }
            if ((sepIdx = sourceFile.indexOf(36)) > 0) {
                sourceFile = sourceFile.substring(0, sepIdx);
            }
            sourceFile = sourceFile + ".java";
        }
        return sourceFile;
    }
}

