/*
 * Decompiled with CFR 0.152.
 */
package org.robovm.debugger.state.classdata;

import org.robovm.debugger.state.classdata.BaseModifiersInfo;
import org.robovm.debugger.state.classdata.ClassInfo;
import org.robovm.debugger.utils.Converter;
import org.robovm.debugger.utils.bytebuffer.ByteBufferMemoryReader;

public class FieldInfo
extends BaseModifiersInfo {
    private int flags;
    private String name;
    private String signature;
    private int offset;
    private ClassInfo typeInfo;

    public void readFieldInfo(ByteBufferMemoryReader reader) {
        this.flags = reader.readInt16();
        this.name = reader.readStringZAtPtr(reader.readPointer());
        if (this.flags >> 12 != 0) {
            switch (this.flags >> 12 & 0xF) {
                case 1: {
                    this.signature = "B";
                    break;
                }
                case 2: {
                    this.signature = "C";
                    break;
                }
                case 3: {
                    this.signature = "D";
                    break;
                }
                case 4: {
                    this.signature = "F";
                    break;
                }
                case 5: {
                    this.signature = "I";
                    break;
                }
                case 6: {
                    this.signature = "J";
                    break;
                }
                case 7: {
                    this.signature = "S";
                    break;
                }
                case 8: {
                    this.signature = "Z";
                }
            }
        } else {
            this.signature = reader.readStringZAtPtr(reader.readPointer());
        }
        this.offset = reader.readInt32();
        if ((this.flags & 0x100) != 0) {
            reader.skip(reader.pointerSize());
        }
    }

    public String name() {
        return this.name;
    }

    public String signature() {
        return this.signature;
    }

    public int offset() {
        return this.offset;
    }

    public ClassInfo typeInfo() {
        return this.typeInfo;
    }

    public void setTypeInfo(ClassInfo typeInfo) {
        this.typeInfo = typeInfo;
    }

    @Override
    protected int convertModifiers() {
        return Converter.fieldModifiers(this.flags);
    }
}

