/*
 * Decompiled with CFR 0.152.
 */
package org.robovm.debugger.state.classdata;

import org.robovm.debugger.state.classdata.BaseModifiersInfo;
import org.robovm.debugger.state.classdata.ClassInfo;
import org.robovm.debugger.utils.Converter;
import org.robovm.debugger.utils.bytebuffer.ByteBufferMemoryReader;
import org.robovm.llvm.debuginfo.DebugMethodInfo;

public class MethodInfo
extends BaseModifiersInfo {
    private int flags;
    private String name;
    private String desc;
    private long implPtr;
    private int methodCodeSize;
    private DebugMethodInfo debugInfo;
    private long bpTableAddr;
    private CallSpec callspec;
    private int spFpOffset;
    private int spFpAlign;

    public void readMethodInfo(ByteBufferMemoryReader reader) {
        this.flags = reader.readInt16();
        short vtableIndex = reader.readInt16();
        this.name = reader.readStringZAtPtr(reader.readPointer());
        if ((this.flags & 0x4000) != 0) {
            switch (reader.readByte()) {
                case 1: {
                    this.desc = "()B";
                    break;
                }
                case 2: {
                    this.desc = "()C";
                    break;
                }
                case 3: {
                    this.desc = "()D";
                    break;
                }
                case 4: {
                    this.desc = "()F";
                    break;
                }
                case 5: {
                    this.desc = "()I";
                    break;
                }
                case 6: {
                    this.desc = "()J";
                    break;
                }
                case 7: {
                    this.desc = "()S";
                    break;
                }
                case 8: {
                    this.desc = "()Z";
                    break;
                }
                case 9: {
                    this.desc = "()V";
                }
            }
        } else {
            this.desc = reader.readStringZAtPtr(reader.readPointer());
        }
        if ((this.flags & 0x800) != 0) {
            reader.skip(reader.pointerSize());
        }
        long synchronizedImpl = 0L;
        long linetable = 0L;
        if (!this.isAbstract()) {
            this.implPtr = reader.readPointer();
            this.methodCodeSize = reader.readInt32();
            if (this.isSynchronized()) {
                synchronizedImpl = reader.readPointer();
            }
            if (!this.isNative()) {
                linetable = reader.readPointer();
            }
        }
        long targetFnPtr = 0L;
        if (this.isBroBridge()) {
            targetFnPtr = reader.readPointer();
        }
        long callbackImpl = 0L;
        if (this.isBroCallback()) {
            callbackImpl = reader.readPointer();
        }
    }

    public String name() {
        return this.name;
    }

    public String signature() {
        return this.desc;
    }

    public long implPtr() {
        return this.implPtr;
    }

    public int methodCodeSize() {
        return this.methodCodeSize;
    }

    public DebugMethodInfo debugInfo() {
        return this.debugInfo;
    }

    public void setDebugInfo(DebugMethodInfo debugInfo, int spFpOffset, int spFpAlign) {
        this.debugInfo = debugInfo;
        this.spFpAlign = spFpAlign;
        this.spFpOffset = spFpOffset;
    }

    public void setBpTableAddr(long addr) {
        this.bpTableAddr = addr;
    }

    public long bpTableAddr() {
        return this.bpTableAddr;
    }

    public int spFpOffset() {
        return this.spFpOffset;
    }

    public int spFpAlign() {
        return this.spFpAlign;
    }

    boolean isBroCallback() {
        return (this.flags & 0x2000) != 0;
    }

    boolean isBroBridge() {
        return (this.flags & 0x1000) != 0;
    }

    public void markAsNative() {
        this.flags |= 0x80;
        this.reloadModifiers();
    }

    public CallSpec callspec() {
        return this.callspec;
    }

    public void setCallspec(CallSpec callspec) {
        this.callspec = callspec;
    }

    @Override
    protected int convertModifiers() {
        return Converter.methodModifiers(this.flags);
    }

    public static class CallSpec {
        public final ClassInfo returnType;
        public final ClassInfo[] arguments;

        public CallSpec(ClassInfo returnType, ClassInfo[] arguments) {
            this.returnType = returnType;
            this.arguments = arguments;
        }
    }
}

