/*
 * Decompiled with CFR 0.152.
 */
package org.robovm.debugger.utils.bytebuffer;

import org.robovm.debugger.utils.bytebuffer.ByteBufferReader;
import org.robovm.debugger.utils.bytebuffer.RangeByteBufferReader;

public class ByteBufferMemoryReader
extends RangeByteBufferReader {
    private final MemoryRegion[] regions;
    private MemoryRegion activeRegion;

    public ByteBufferMemoryReader(ByteBufferReader other, int offs, int size, boolean is64bit, MemoryRegion[] regions) {
        super(other, offs, size, is64bit);
        this.regions = regions;
    }

    public ByteBufferMemoryReader setAddress(long addr) {
        this.activeRegion = this.findRegion(addr);
        if (this.activeRegion == null) {
            throw new IllegalArgumentException("there is no region to read addr @" + Long.toHexString(addr));
        }
        super.setPosition((long)this.activeRegion.offset + (addr - this.activeRegion.startAddr));
        return this;
    }

    private MemoryRegion findRegion(long addr) {
        if (this.activeRegion != null && addr >= this.activeRegion.startAddr && addr <= this.activeRegion.endAddr) {
            return this.activeRegion;
        }
        int left = 0;
        int right = this.regions.length - 1;
        while (right >= left) {
            int middle = (left + right) / 2;
            MemoryRegion r = this.regions[middle];
            if (addr < r.startAddr) {
                right = middle - 1;
                continue;
            }
            if (addr > r.endAddr) {
                left = middle + 1;
                continue;
            }
            return r;
        }
        return null;
    }

    @Override
    protected void expects(int bytes) {
        if (this.activeRegion == null) {
            throw new IllegalArgumentException("Address has not been set but read is performed!");
        }
        int currentPos = this.position();
        if ((long)currentPos > this.activeRegion.endAddr || (long)(currentPos + bytes) > this.activeRegion.endAddr) {
            throw new IllegalArgumentException("Cross memory region read is not allowed !");
        }
        super.expects(bytes);
    }

    public long address() {
        if (this.activeRegion == null) {
            throw new IllegalArgumentException("Address has not been set!");
        }
        return this.activeRegion.startAddr + (long)(this.position() - this.activeRegion.offset);
    }

    @Override
    public void skip(int bytesToSkip) {
        this.setAddress(this.address() + (long)bytesToSkip);
    }

    public String readStringZAtPtr(long addr) {
        MemoryRegion r = this.findRegion(addr);
        if (r == null) {
            throw new IllegalArgumentException("there is no region to read string @" + Long.toHexString(addr));
        }
        return this.readStringZ((int)((long)r.offset + (addr - r.startAddr)));
    }

    public static class MemoryRegion {
        private final long startAddr;
        private final long endAddr;
        private final int offset;

        public MemoryRegion(long startAddr, long endAddr, int offset) {
            this.startAddr = startAddr;
            this.endAddr = endAddr;
            this.offset = offset;
        }
    }
}

