/*
 * Decompiled with CFR 0.152.
 */
package org.robovm.compiler.util.io;

import com.dd.plist.NSDictionary;
import com.dd.plist.NSNumber;
import com.dd.plist.NSObject;
import com.dd.plist.PropertyListParser;
import java.io.File;
import java.io.IOException;
import java.nio.file.FileStore;
import java.nio.file.Files;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.List;
import org.apache.commons.io.FileUtils;
import org.robovm.compiler.config.Arch;
import org.robovm.compiler.config.Config;
import org.robovm.compiler.config.OS;
import org.robovm.compiler.log.Logger;
import org.robovm.compiler.util.Executor;

public class RamDiskTools {
    private static final String ROBOVM_RAM_DISK_PATH = "/Volumes/RoboVM RAM Disk";
    private static final long MIN_FREE_SPACE = 0x19000000L;
    private File newCacheDir;
    private File newTmpDir;

    public File getCacheDir() {
        return this.newCacheDir;
    }

    public File getTmpDir() {
        return this.newTmpDir;
    }

    public void setupRamDisk(Config config, File cacheDir, File tmpDir) {
        this.newCacheDir = cacheDir;
        this.newTmpDir = tmpDir;
        if (OS.getDefaultOS() != OS.macosx) {
            return;
        }
        File volume = new File(ROBOVM_RAM_DISK_PATH);
        if (!volume.exists()) {
            try {
                FileStore store = Files.getFileStore(new File(System.getProperty("user.home")).toPath());
                String plist = new Executor(Logger.NULL_LOGGER, "diskutil").args("info", "-plist", store.name()).execCapture();
                NSDictionary dict = (NSDictionary)PropertyListParser.parse(plist.getBytes("UTF-8"));
                NSObject value = dict.objectForKey("SolidState");
                if (value == null || value instanceof NSNumber && !((NSNumber)value).boolValue()) {
                    config.getLogger().warn("RoboVM has detected that you are running on a slow HDD. Please consider mounting a RAM disk.\nTo create a 2GB RAM disk, run this in your terminal:\nSIZE=2048 ; diskutil erasevolume HFS+ 'RoboVM RAM Disk' `hdiutil attach -nomount ram://$((SIZE * 2048))`\nSee http://docs.robovm.com/ for more info", new Object[0]);
                }
            }
            catch (Throwable t) {
                t.printStackTrace();
            }
            return;
        }
        try {
            File newCacheDir;
            FileStore store = Files.getFileStore(volume.toPath());
            if (store.getUsableSpace() < 0x19000000L) {
                this.cleanRamDisk(store, volume, config);
                if (store.getUsableSpace() < 0x19000000L) {
                    config.getLogger().info("Couldn't free enough space on RAM disk, using hard drive", new Object[0]);
                    return;
                }
            }
            if (!(newCacheDir = new File(volume, "cache")).exists() && !newCacheDir.mkdirs()) {
                config.getLogger().info("Couldn't create cache directory on RAM disk, using hard drive", new Object[0]);
                return;
            }
            File newTmpDir = new File(volume, "tmp");
            if (!newTmpDir.exists() && !newTmpDir.mkdirs()) {
                config.getLogger().info("Couldn't create tmp directory on RAM disk, using hard drive", new Object[0]);
                return;
            }
            newTmpDir = new File(newTmpDir, tmpDir.getAbsolutePath());
            config.getLogger().info("Using RAM disk at %s for cache and tmp directory", ROBOVM_RAM_DISK_PATH);
            this.newCacheDir = newCacheDir;
            this.newTmpDir = newTmpDir;
        }
        catch (Throwable t) {
            config.getLogger().error("Couldn't setup RAM disk, using hard drive, %s", t.getMessage());
            this.newCacheDir = cacheDir;
            this.newTmpDir = tmpDir;
        }
    }

    private void cleanRamDisk(FileStore store, File volume, Config config) {
        try {
            if (store.getUsableSpace() < 0x19000000L) {
                this.cleanCache(store, volume, config);
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    private void cleanCache(FileStore store, File volume, Config config) throws IOException {
        OS currOs = config.getOs();
        Arch currArch = config.getArch();
        CacheDir currCacheDir = this.constructCacheDir(volume, currOs, currArch, config.isDebug());
        ArrayList<CacheDir> cacheDirs = new ArrayList<CacheDir>();
        for (OS os : OS.values()) {
            for (Arch arch : Arch.values()) {
                for (boolean isDebug : new boolean[]{false, true}) {
                    CacheDir cacheDir = this.constructCacheDir(volume, os, arch, isDebug);
                    if (cacheDir == null || cacheDir.directory.equals(currCacheDir.directory)) continue;
                    cacheDirs.add(cacheDir);
                }
            }
        }
        Collections.sort(cacheDirs, new Comparator<CacheDir>(){

            @Override
            public int compare(CacheDir o1, CacheDir o2) {
                return new Date(o1.lastModified).compareTo(new Date(o2.lastModified));
            }
        });
        if (currCacheDir != null) {
            cacheDirs.add(currCacheDir);
        }
        for (CacheDir dir : cacheDirs) {
            for (File file : dir.objFiles) {
                file.delete();
                if (store.getUsableSpace() <= 0x19000000L) continue;
                return;
            }
        }
        FileUtils.deleteDirectory(new File(volume, "cache"));
    }

    private CacheDir constructCacheDir(File volume, OS os, Arch arch, boolean isDebug) {
        File dir = new File(volume, "cache/" + os.toString() + "/" + arch.toString() + "/" + (isDebug ? "debug" : "release"));
        if (!dir.exists()) {
            return null;
        }
        ArrayList<File> objFiles = new ArrayList<File>(FileUtils.listFiles(dir, new String[]{"o"}, true));
        Collections.sort(objFiles, new Comparator<File>(){

            @Override
            public int compare(File f1, File f2) {
                return new Date(f2.lastModified()).compareTo(new Date(f1.lastModified()));
            }
        });
        long lastModified = 0L;
        for (File file : objFiles) {
            lastModified = Math.max(lastModified, file.lastModified());
        }
        return new CacheDir(dir, objFiles, lastModified);
    }

    static class CacheDir {
        File directory;
        List<File> objFiles;
        long lastModified;

        public CacheDir(File directory, List<File> objFiles, long lastModified) {
            this.directory = directory;
            this.objFiles = objFiles;
            this.lastModified = lastModified;
        }
    }
}

