/*
 * Decompiled with CFR 0.152.
 */
package org.robovm.debugger.debuginfo;

import org.robovm.debugger.debuginfo.DebuggerDebugAllocaInfo;
import org.robovm.debugger.debuginfo.DebuggerDebugVariableInfo;
import org.robovm.debugger.utils.Pair;

public class DebuggerDebugMethodInfo {
    private final String name;
    private final int startLine;
    private final int finalLine;
    private final int spFpOffset;
    private final int spFpAlign;
    private final DebuggerDebugVariableInfo[] localvariables;
    private final DebuggerDebugVariableInfo[][] sliceVariables;
    private final DebuggerDebugAllocaInfo[][] sliceAllocas;
    private final int[] offsets;
    private final int[] offsetSliceIndexes;

    DebuggerDebugMethodInfo(RawData rawData) {
        this.name = rawData.signature;
        this.startLine = rawData.startLine;
        this.finalLine = rawData.finalLine;
        if (rawData.spFpOffset != 0) {
            this.spFpOffset = (rawData.spFpOffset & 0xFFFFFFF) << 2;
            this.spFpAlign = (rawData.spFpOffset >> 28) + 1 << 2;
        } else {
            this.spFpOffset = 0;
            this.spFpAlign = 0;
        }
        this.localvariables = rawData.variables;
        this.offsets = rawData.offsets;
        this.offsetSliceIndexes = rawData.offsetSliceIndexes;
        int sliceCount = rawData.slices.length;
        this.sliceVariables = new DebuggerDebugVariableInfo[sliceCount][];
        this.sliceAllocas = new DebuggerDebugAllocaInfo[sliceCount][];
        for (int sliceIdx = 0; sliceIdx < sliceCount; ++sliceIdx) {
            int[] sliceData = rawData.slices[sliceIdx];
            int varCount = sliceData.length / 2;
            this.sliceVariables[sliceIdx] = new DebuggerDebugVariableInfo[varCount];
            DebuggerDebugVariableInfo[] variables = this.sliceVariables[sliceIdx];
            this.sliceAllocas[sliceIdx] = new DebuggerDebugAllocaInfo[varCount];
            DebuggerDebugAllocaInfo[] allocas = this.sliceAllocas[sliceIdx];
            for (int idx = 0; idx < varCount; ++idx) {
                int varIdx = sliceData[idx * 2];
                int allocaIdx = sliceData[idx * 2 + 1];
                variables[idx] = this.localvariables[varIdx];
                allocas[idx] = rawData.allocas[allocaIdx];
            }
        }
    }

    public String signature() {
        return this.name;
    }

    public DebuggerDebugVariableInfo[] localvariables() {
        return this.localvariables;
    }

    public int startLine() {
        return this.startLine;
    }

    public int finalLine() {
        return this.finalLine;
    }

    public int getSpFpOffset() {
        return this.spFpOffset;
    }

    public int getSpFpAlign() {
        return this.spFpAlign;
    }

    public Pair<DebuggerDebugVariableInfo[], DebuggerDebugAllocaInfo[]> getVisibleVariables(int offset) {
        int offsetIdx = DebuggerDebugMethodInfo.binarySearchOffset(this.offsets, offset);
        if (offsetIdx < 0) {
            return null;
        }
        int sliceIdx = this.offsetSliceIndexes[offsetIdx];
        return new Pair<DebuggerDebugVariableInfo[], DebuggerDebugAllocaInfo[]>(this.sliceVariables[sliceIdx], this.sliceAllocas[sliceIdx]);
    }

    private static int binarySearchOffset(int[] array, int value) {
        if (array == null || array.length == 0) {
            return -1;
        }
        if (array[0] > value) {
            return -1;
        }
        int leftIdx = 0;
        int rightIdx = array.length - 1;
        while (leftIdx < rightIdx) {
            int centerIdx = (leftIdx + rightIdx + 1) / 2;
            int cv = array[centerIdx];
            if (cv <= value) {
                leftIdx = centerIdx;
                continue;
            }
            rightIdx = centerIdx - 1;
        }
        return leftIdx;
    }

    public static class RawData {
        final String signature;
        final DebuggerDebugVariableInfo[] variables;
        final DebuggerDebugAllocaInfo[] allocas;
        final int[] offsets;
        final int[] offsetSliceIndexes;
        final int[][] slices;
        final int startLine;
        final int finalLine;
        final int spFpOffset;

        public RawData(String methodName, int startLine, int finalLine, int spfpOffset, DebuggerDebugVariableInfo[] variables, DebuggerDebugAllocaInfo[] allocas, int[] offsets, int[] offsetSliceIndexes, int[][] slices) {
            this.signature = methodName;
            this.startLine = startLine;
            this.finalLine = finalLine;
            this.spFpOffset = spfpOffset;
            this.variables = variables;
            this.allocas = allocas;
            this.offsets = offsets;
            this.offsetSliceIndexes = offsetSliceIndexes;
            this.slices = slices;
        }
    }
}

