/*
 * Decompiled with CFR 0.152.
 */
package org.robovm.debugger.jdwp.handlers.vm;

import org.robovm.debugger.jdwp.protocol.IJdwpRequestHandler;
import org.robovm.debugger.state.VmDebuggerState;
import org.robovm.debugger.state.classdata.ClassInfo;
import org.robovm.debugger.utils.Converter;
import org.robovm.debugger.utils.bytebuffer.DataBufferReader;
import org.robovm.debugger.utils.bytebuffer.DataBufferWriter;

public class JdwpVmClassesBySignatureHandler
implements IJdwpRequestHandler {
    private final VmDebuggerState state;

    public JdwpVmClassesBySignatureHandler(VmDebuggerState state) {
        this.state = state;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public short handle(DataBufferReader payload, DataBufferWriter output) {
        String signature = payload.readStringWithLen();
        Object object = this.state.centralLock();
        synchronized (object) {
            ClassInfo classInfo = this.state.classInfoLoader().classInfoBySignature(signature);
            if (classInfo != null) {
                output.writeInt32(1);
                output.writeByte(Converter.jdwpTypeTag(classInfo));
                output.writeLong(classInfo.refId());
                output.writeInt32(Converter.jdwpClassStatus(classInfo));
            } else {
                output.writeInt32(0);
            }
        }
        return 0;
    }

    @Override
    public byte getCommandSet() {
        return 1;
    }

    @Override
    public byte getCommand() {
        return 2;
    }

    public String toString() {
        return "VirtualMachine(1).ClassesBySignature(2)";
    }
}

