/*
 * Decompiled with CFR 0.152.
 */
package org.robovm.llvm.binding;

import org.robovm.llvm.binding.LLVMJNI;
import org.robovm.llvm.binding.TypeRef;

public class TypeRefArray {
    private transient long swigCPtr;
    protected transient boolean swigCMemOwn;

    protected TypeRefArray(long cPtr, boolean cMemoryOwn) {
        this.swigCMemOwn = cMemoryOwn;
        this.swigCPtr = cPtr;
    }

    protected static long getCPtr(TypeRefArray obj) {
        return obj == null ? 0L : obj.swigCPtr;
    }

    protected void finalize() {
        this.delete();
    }

    public synchronized void delete() {
        if (this.swigCPtr != 0L) {
            if (this.swigCMemOwn) {
                this.swigCMemOwn = false;
                LLVMJNI.delete_TypeRefArray(this.swigCPtr);
            }
            this.swigCPtr = 0L;
        }
    }

    public void setValue(TypeRef value) {
        LLVMJNI.TypeRefArray_value_set(this.swigCPtr, this, TypeRef.getCPtr(value));
    }

    public TypeRef getValue() {
        long cPtr = LLVMJNI.TypeRefArray_value_get(this.swigCPtr, this);
        return cPtr == 0L ? null : new TypeRef(cPtr, false);
    }

    public TypeRefArray(int nelements) {
        this(LLVMJNI.new_TypeRefArray(nelements), true);
    }

    public TypeRef get(int index) {
        long cPtr = LLVMJNI.TypeRefArray_get(this.swigCPtr, this, index);
        return cPtr == 0L ? null : new TypeRef(cPtr, false);
    }

    public void set(int index, TypeRef value) {
        LLVMJNI.TypeRefArray_set(this.swigCPtr, this, index, TypeRef.getCPtr(value));
    }
}

