/*
 * Decompiled with CFR 0.152.
 */
package soot;

import java.util.LinkedList;
import soot.ResolutionFailedException;
import soot.Scene;
import soot.SootClass;
import soot.SootField;
import soot.SootFieldRef;
import soot.Type;
import soot.jimple.toolkits.typing.TypeAssigner;

class AbstractSootFieldRef
implements SootFieldRef {
    private final SootClass declaringClass;
    private final String name;
    private final Type type;
    private final boolean isStatic;

    public AbstractSootFieldRef(SootClass declaringClass, String name, Type type, boolean isStatic) {
        this.declaringClass = declaringClass;
        this.name = name;
        this.type = type;
        this.isStatic = isStatic;
        if (declaringClass == null) {
            throw new RuntimeException("Attempt to create SootFieldRef with null class");
        }
        if (name == null) {
            throw new RuntimeException("Attempt to create SootFieldRef with null name");
        }
        if (type == null) {
            throw new RuntimeException("Attempt to create SootFieldRef with null type");
        }
    }

    @Override
    public SootClass declaringClass() {
        return this.declaringClass;
    }

    @Override
    public String name() {
        return this.name;
    }

    @Override
    public Type type() {
        return this.type;
    }

    @Override
    public boolean isStatic() {
        return this.isStatic;
    }

    @Override
    public String getSignature() {
        return SootField.getSignature(this.declaringClass, this.name, this.type);
    }

    @Override
    public SootField resolve() {
        return this.resolve(null);
    }

    private SootField checkStatic(SootField ret) {
        if (ret.isStatic() != this.isStatic() && !ret.isPhantom() && !TypeAssigner.v().ignoreWrongStaticNess()) {
            throw new ResolutionFailedException("Resolved " + this + " to " + ret + " which has wrong static-ness");
        }
        return ret;
    }

    private SootField resolve(StringBuffer trace) {
        SootClass cl = this.declaringClass;
        while (true) {
            if (trace != null) {
                trace.append("Looking in " + cl + " which has fields " + cl.getFields() + "\n");
            }
            if (cl.declaresField(this.name, this.type)) {
                return this.checkStatic(cl.getField(this.name, this.type));
            }
            if (Scene.v().allowsPhantomRefs() && cl.isPhantom()) {
                SootField f = new SootField(this.name, this.type, this.isStatic() ? 8 : 0);
                f.setPhantom(true);
                cl.addField(f);
                return f;
            }
            LinkedList<SootClass> queue = new LinkedList<SootClass>();
            queue.addAll(cl.getInterfaces());
            while (!queue.isEmpty()) {
                SootClass iface = (SootClass)queue.removeFirst();
                if (trace != null) {
                    trace.append("Looking in " + iface + " which has fields " + iface.getFields() + "\n");
                }
                if (iface.declaresField(this.name, this.type)) {
                    return this.checkStatic(iface.getField(this.name, this.type));
                }
                queue.addAll(iface.getInterfaces());
            }
            if (!cl.hasSuperclass()) break;
            cl = cl.getSuperclass();
        }
        if (trace == null) {
            throw new FieldResolutionFailedException();
        }
        return null;
    }

    public String toString() {
        return this.getSignature();
    }

    public class FieldResolutionFailedException
    extends ResolutionFailedException {
        public FieldResolutionFailedException() {
            super("Class " + AbstractSootFieldRef.this.declaringClass + " doesn't have field " + AbstractSootFieldRef.this.name + " : " + AbstractSootFieldRef.this.type + "; failed to resolve in superclasses and interfaces");
        }

        @Override
        public String toString() {
            StringBuffer ret = new StringBuffer();
            ret.append(super.toString());
            AbstractSootFieldRef.this.resolve(ret);
            return ret.toString();
        }
    }
}

