/*
 * Decompiled with CFR 0.152.
 */
package soot.util;

import java.text.StringCharacterIterator;

public class StringTools {
    public static final String lineSeparator = System.getProperty("line.separator");

    public static String getEscapedStringOf(String fromString) {
        char c;
        StringBuffer whole = new StringBuffer();
        StringBuffer mini = new StringBuffer();
        char[] fromStringArray = fromString.toCharArray();
        char cr = lineSeparator.charAt(0);
        int n = -1;
        if (lineSeparator.length() == 2) {
            c = lineSeparator.charAt(1);
        }
        for (char element : fromStringArray) {
            char ch = element;
            if ((ch >= ' ' && ch <= '~' || ch == cr || ch == c) && ch != '\\') {
                whole.append(ch);
                continue;
            }
            mini.setLength(0);
            mini.append(Integer.toHexString(ch));
            while (mini.length() < 4) {
                mini.insert(0, "0");
            }
            mini.insert(0, "\\u");
            whole.append(mini.toString());
        }
        return whole.toString();
    }

    public static String getQuotedStringOf(String fromString) {
        StringBuffer toStringBuffer = new StringBuffer();
        char[] fromStringArray = fromString.toCharArray();
        toStringBuffer.append("\"");
        for (char ch : fromStringArray) {
            if (ch == '\\') {
                toStringBuffer.append("\\\\");
                continue;
            }
            if (ch == '\'') {
                toStringBuffer.append("\\'");
                continue;
            }
            if (ch == '\"') {
                toStringBuffer.append("\\\"");
                continue;
            }
            if (ch == '\n') {
                toStringBuffer.append("\\n");
                continue;
            }
            if (ch == '\t') {
                toStringBuffer.append("\\t");
                continue;
            }
            if (ch == '\r') {
                toStringBuffer.append("\\r");
                continue;
            }
            if (ch == '\f') {
                toStringBuffer.append("\\f");
                continue;
            }
            if (ch >= ' ' && ch <= '~') {
                toStringBuffer.append(ch);
                continue;
            }
            toStringBuffer.append(StringTools.getUnicodeStringFromChar(ch));
        }
        toStringBuffer.append("\"");
        return toStringBuffer.toString();
    }

    public static String getUnicodeStringFromChar(char ch) {
        String s = Integer.toHexString(ch);
        String padding = null;
        switch (s.length()) {
            case 1: {
                padding = "000";
                break;
            }
            case 2: {
                padding = "00";
                break;
            }
            case 3: {
                padding = "0";
                break;
            }
            case 4: {
                padding = "";
            }
        }
        return "\\u" + padding + s;
    }

    public static String getUnEscapedStringOf(String str) {
        StringBuffer buf = new StringBuffer();
        StringCharacterIterator iter = new StringCharacterIterator(str);
        char ch = iter.first();
        while (ch != '\uffff') {
            if (ch != '\\') {
                buf.append(ch);
            } else {
                ch = iter.next();
                if (ch == '\\') {
                    buf.append(ch);
                } else {
                    char format = StringTools.getCFormatChar(ch);
                    if (format != '\u0000') {
                        buf.append(format);
                    } else if (ch == 'u') {
                        StringBuffer mini = new StringBuffer(4);
                        for (int i = 0; i < 4; ++i) {
                            mini.append(iter.next());
                        }
                        ch = (char)Integer.parseInt(mini.toString(), 16);
                        buf.append(ch);
                    } else {
                        throw new RuntimeException("Unexpected char: " + ch);
                    }
                }
            }
            ch = iter.next();
        }
        return buf.toString();
    }

    public static char getCFormatChar(char c) {
        char res;
        switch (c) {
            case 'n': {
                res = '\n';
                break;
            }
            case 't': {
                res = '\t';
                break;
            }
            case 'r': {
                res = '\r';
                break;
            }
            case 'b': {
                res = '\b';
                break;
            }
            case '\"': {
                res = '\"';
                break;
            }
            case '\'': {
                res = '\'';
                break;
            }
            default: {
                res = '\u0000';
            }
        }
        return res;
    }

    public static String replaceAll(String orig, String toBeReplaced, String replacement) {
        int quarryLength = toBeReplaced.length();
        if (quarryLength <= 0) {
            return orig;
        }
        int index = orig.indexOf(toBeReplaced);
        if (index < 0) {
            return orig;
        }
        int from = 0;
        StringBuffer sb = quarryLength < replacement.length() ? new StringBuffer(orig.length()) : new StringBuffer(orig.length() * 2);
        do {
            sb.append(orig.substring(from, index));
            sb.append(replacement);
        } while ((index = orig.indexOf(toBeReplaced, from = index + quarryLength)) >= 0);
        sb.append(orig.substring(from));
        return sb.toString();
    }
}

