/*
 * Decompiled with CFR 0.152.
 */
package org.robovm.compiler;

import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import org.apache.commons.lang3.tuple.ImmutableTriple;
import org.apache.commons.lang3.tuple.Triple;
import org.robovm.compiler.clazz.Clazz;
import org.robovm.compiler.clazz.ClazzInfo;
import org.robovm.compiler.clazz.Dependency;
import org.robovm.compiler.clazz.InvokeMethodDependency;
import org.robovm.compiler.clazz.MethodDependency;
import org.robovm.compiler.clazz.MethodInfo;
import org.robovm.compiler.clazz.SuperMethodDependency;
import org.robovm.compiler.config.Config;

public class DependencyGraph {
    private final Set<ClassNode> roots = new HashSet<ClassNode>();
    private final Map<String, ClassNode> classNodes = new HashMap<String, ClassNode>();
    private final Map<String, MethodNode> methodNodes = new HashMap<String, MethodNode>();
    private final Set<Node> reachableNodes = new HashSet<Node>();
    private final Config.TreeShakerMode treeShakerMode;

    public DependencyGraph(Config.TreeShakerMode treeShakerMode) {
        this.treeShakerMode = treeShakerMode;
    }

    public void add(Clazz clazz, boolean root, Collection<MethodInfo> forcedLinkedMethods) {
        this.reachableNodes.clear();
        ClassNode classNode = this.getClassNode(clazz.getInternalName());
        if (root) {
            this.roots.add(classNode);
        }
        ClazzInfo ci = clazz.getClazzInfo();
        for (Dependency dep : ci.getDependencies()) {
            MethodDependency mdep;
            if (dep instanceof InvokeMethodDependency) {
                mdep = (InvokeMethodDependency)dep;
                classNode.addEgde(this.getMethodNode(mdep), mdep.isWeak());
                continue;
            }
            if (dep instanceof SuperMethodDependency) {
                mdep = (SuperMethodDependency)dep;
                classNode.addEgde(this.getMethodNode(mdep), mdep.isWeak());
                continue;
            }
            classNode.addEgde(this.getClassNode(dep.getClassName()), dep.isWeak());
        }
        for (MethodInfo mi : ci.getMethods()) {
            boolean strong = root || mi.isCallback() || mi.isStatic() && "<clinit>".equals(mi.getName()) && "()V".equals(mi.getDesc()) || ci.isEnum() && mi.isStatic() && "values".equals(mi.getName()) && mi.getDesc().equals("()[L" + clazz.getInternalName() + ";") || ci.isStruct() && mi.isStatic() && ("sizeOf".equals(mi.getName()) || "$attr$stretMetadata".equals(mi.getName())) && "()I".equals(mi.getDesc()) || forcedLinkedMethods.contains(mi);
            MethodNode methodNode = this.getMethodNode(clazz, mi);
            classNode.addEgde(methodNode, !strong);
            methodNode.addEgde(classNode, false);
            for (Dependency dep : mi.getDependencies()) {
                MethodDependency mdep;
                if (dep instanceof InvokeMethodDependency) {
                    mdep = (InvokeMethodDependency)dep;
                    methodNode.addEgde(this.getMethodNode(mdep), mdep.isWeak());
                    continue;
                }
                if (dep instanceof SuperMethodDependency) {
                    mdep = (SuperMethodDependency)dep;
                    this.getMethodNode(mdep).addEgde(methodNode, false);
                    continue;
                }
                methodNode.addEgde(this.getClassNode(dep.getClassName()), dep.isWeak());
            }
        }
    }

    private ClassNode getClassNode(String className) {
        ClassNode node = this.classNodes.get(className);
        if (node == null) {
            node = new ClassNode(className);
            this.classNodes.put(className, node);
        }
        return node;
    }

    private MethodNode getMethodNode(String owner, String name, String desc2, boolean weaklyLinked, boolean stronglyLinked) {
        String key = owner + "." + name + desc2;
        MethodNode node = this.methodNodes.get(key);
        if (node == null) {
            node = new MethodNode(owner, name, desc2, weaklyLinked, stronglyLinked);
            this.methodNodes.put(key, node);
        } else {
            if (weaklyLinked) {
                node.weaklyLinked = true;
            }
            if (stronglyLinked) {
                node.stronglyLinked = true;
            }
        }
        return node;
    }

    private MethodNode getMethodNode(Clazz clazz, MethodInfo mi) {
        return this.getMethodNode(clazz.getInternalName(), mi.getName(), mi.getDesc(), mi.isWeaklyLinked(), mi.isStronglyLinked());
    }

    private MethodNode getMethodNode(MethodDependency dep) {
        return this.getMethodNode(dep.getOwner(), dep.getMethodName(), dep.getMethodDesc(), false, false);
    }

    public Set<String> findReachableClasses() {
        this.validateReachableNodes();
        HashSet<String> classes = new HashSet<String>();
        for (Node node : this.reachableNodes) {
            if (!(node instanceof ClassNode)) continue;
            classes.add(((ClassNode)node).className);
        }
        return classes;
    }

    public Set<Triple<String, String, String>> findReachableMethods() {
        this.validateReachableNodes();
        HashSet<Triple<String, String, String>> methods = new HashSet<Triple<String, String, String>>();
        for (Node node : this.reachableNodes) {
            if (!(node instanceof MethodNode)) continue;
            MethodNode mnode = (MethodNode)node;
            methods.add(new ImmutableTriple<String, String, String>(mnode.owner, mnode.name, mnode.desc));
        }
        return methods;
    }

    private void validateReachableNodes() {
        if (this.reachableNodes.isEmpty()) {
            for (ClassNode node : this.roots) {
                this.visitReachableNodes(node, this.reachableNodes);
            }
        }
    }

    private void visitReachableNodes(Node node, Set<Node> visited) {
        Node visiting;
        HashSet<Node> pending = new HashSet<Node>();
        LinkedList<Node> queue = new LinkedList<Node>();
        pending.add(node);
        queue.add(node);
        while ((visiting = (Node)queue.poll()) != null) {
            if (!pending.remove(visiting)) {
                throw new IllegalStateException();
            }
            if (!visited.add(visiting)) continue;
            for (Node child : visiting.strongEdges) {
                if (!pending.add(child)) continue;
                queue.add(child);
            }
            for (Node child : visiting.weakEdges) {
                MethodNode mnode;
                if (this.treeShakerMode == Config.TreeShakerMode.conservative && child instanceof MethodNode) {
                    mnode = (MethodNode)child;
                    if (mnode.isWeaklyLinked() || !pending.add(child)) continue;
                    queue.add(child);
                    continue;
                }
                if (this.treeShakerMode == Config.TreeShakerMode.aggressive) {
                    if (!(child instanceof MethodNode) || !(mnode = (MethodNode)child).isStronglyLinked() && (mnode.isWeaklyLinked() || !"<init>".equals(mnode.name)) || !pending.add(child)) continue;
                    queue.add(child);
                    continue;
                }
                if (!pending.add(child)) continue;
                queue.add(child);
            }
        }
    }

    public TreeSet<String> getAllClasses() {
        TreeSet<String> result = new TreeSet<String>();
        for (ClassNode node : this.classNodes.values()) {
            result.add(node.className);
        }
        return result;
    }

    private static class ClassNode
    extends Node {
        private final String className;

        private ClassNode(String className) {
            this.className = className;
        }

        public int hashCode() {
            int prime = 31;
            int result = 1;
            result = 31 * result + (this.className == null ? 0 : this.className.hashCode());
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            ClassNode other = (ClassNode)obj;
            return !(this.className == null ? other.className != null : !this.className.equals(other.className));
        }
    }

    private static class MethodNode
    extends Node {
        private final String owner;
        private final String name;
        private final String desc;
        private boolean weaklyLinked;
        private boolean stronglyLinked;

        private MethodNode(String owner, String name, String desc2, boolean weaklyLinked, boolean stronglyLinked) {
            this.owner = owner;
            this.name = name;
            this.desc = desc2;
            this.weaklyLinked = weaklyLinked;
            this.stronglyLinked = stronglyLinked;
        }

        public boolean isWeaklyLinked() {
            return this.weaklyLinked;
        }

        public boolean isStronglyLinked() {
            return this.stronglyLinked;
        }

        public int hashCode() {
            int prime = 31;
            int result = 1;
            result = 31 * result + (this.desc == null ? 0 : this.desc.hashCode());
            result = 31 * result + (this.name == null ? 0 : this.name.hashCode());
            result = 31 * result + (this.owner == null ? 0 : this.owner.hashCode());
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            MethodNode other = (MethodNode)obj;
            if (this.desc == null ? other.desc != null : !this.desc.equals(other.desc)) {
                return false;
            }
            if (this.name == null ? other.name != null : !this.name.equals(other.name)) {
                return false;
            }
            return !(this.owner == null ? other.owner != null : !this.owner.equals(other.owner));
        }
    }

    private static abstract class Node {
        private final Set<Node> weakEdges = new HashSet<Node>();
        private final Set<Node> strongEdges = new HashSet<Node>();

        private Node() {
        }

        public void addEgde(Node to, boolean weak) {
            (weak ? this.weakEdges : this.strongEdges).add(to);
        }
    }
}

