/*
 * Decompiled with CFR 0.152.
 */
package org.robovm.compiler.plugin.debug.kotlin;

import java.util.ArrayList;
import org.robovm.compiler.plugin.debug.DebugInformationPlugin;

public class KotlinTools {
    private static final String DEBUG_SECTION = "*S KotlinDebug";
    private static final String FILE_SECTION = "*F";
    private static final String LINE_SECTION = "*L";
    private static final String END = "*E";

    public static DebugInformationPlugin.LineNumberMapper parseSMAP(byte[] smapData, String internalName) {
        String mappingInfo = new String(smapData);
        ArrayList<Range> lineMappings = new ArrayList<Range>();
        int debugSectionStart = mappingInfo.indexOf(DEBUG_SECTION);
        if (debugSectionStart < 0) {
            return DebugInformationPlugin.LineNumberMapper.DIRECT;
        }
        mappingInfo = mappingInfo.substring(debugSectionStart + DEBUG_SECTION.length());
        int fileSectionStart = mappingInfo.indexOf(FILE_SECTION) + FILE_SECTION.length();
        int lineSectionAnchor = mappingInfo.indexOf(LINE_SECTION);
        String files = mappingInfo.substring(fileSectionStart, lineSectionAnchor);
        String[] fileEntries = files.trim().split("\\+");
        int ownFileIndex = -1;
        for (String string : fileEntries) {
            String fileInternalName = string.trim();
            if (fileInternalName.isEmpty()) continue;
            int indexEnd = fileInternalName.indexOf(32);
            int index = Integer.parseInt(fileInternalName.substring(0, indexEnd));
            int newLine = fileInternalName.indexOf(10);
            if (!(fileInternalName = fileInternalName.substring(newLine + 1).trim()).equals(internalName)) continue;
            ownFileIndex = index;
            break;
        }
        if (ownFileIndex == -1) {
            return DebugInformationPlugin.LineNumberMapper.DIRECT;
        }
        String[] lines = mappingInfo.substring(lineSectionAnchor + LINE_SECTION.length(), mappingInfo.indexOf(END)).trim().split("\\n");
        int minTargetIndex = Integer.MAX_VALUE;
        int maxTargetIndex = Integer.MIN_VALUE;
        for (String lineMapping : lines) {
            int fileSeparator;
            int fileIndex;
            int targetSplit = lineMapping.indexOf(58);
            String originalPart = lineMapping.substring(0, targetSplit);
            int rangeSeparator = originalPart.indexOf(44);
            if (rangeSeparator < 0) {
                rangeSeparator = targetSplit;
            }
            if ((fileIndex = Integer.parseInt(lineMapping.substring((fileSeparator = lineMapping.indexOf(35)) + 1, rangeSeparator))) != ownFileIndex) continue;
            int originalIndex = Integer.parseInt(originalPart.substring(0, fileSeparator));
            int range = rangeSeparator == targetSplit ? 1 : Integer.parseInt(originalPart.substring(rangeSeparator + 1, targetSplit));
            int targetIndex = Integer.parseInt(lineMapping.substring(targetSplit + 1));
            if (targetIndex < minTargetIndex) {
                minTargetIndex = targetIndex;
            }
            if (targetIndex + range - 1 > maxTargetIndex) {
                maxTargetIndex = targetIndex + range - 1;
            }
            lineMappings.add(new Range(originalIndex, targetIndex, targetIndex + range - 1));
        }
        if (lineMappings.size() == 1) {
            Range range = (Range)lineMappings.get(0);
            int targetIndexStart = range.targetIndexStart;
            int targetIndexEnd = range.targetIndexEnd;
            int originalIndex = range.originalIndex;
            return l -> {
                if (l >= targetIndexStart && l <= targetIndexEnd) {
                    return originalIndex + l - targetIndexStart;
                }
                return l;
            };
        }
        if (lineMappings.size() > 1) {
            int n = minTargetIndex;
            int maxLine = maxTargetIndex;
            return l -> {
                if (l >= minLine && l <= maxLine) {
                    for (Range r : lineMappings) {
                        if (l < r.targetIndexStart || l > r.targetIndexEnd) continue;
                        return r.originalIndex + l - r.targetIndexStart;
                    }
                }
                return l;
            };
        }
        return DebugInformationPlugin.LineNumberMapper.DIRECT;
    }

    private static class Range {
        private final int originalIndex;
        private final int targetIndexStart;
        private final int targetIndexEnd;

        Range(int originalIndex, int targetIndexStart, int targetIndexEnd) {
            this.originalIndex = originalIndex;
            this.targetIndexStart = targetIndexStart;
            this.targetIndexEnd = targetIndexEnd;
        }
    }
}

