/*
 * Decompiled with CFR 0.152.
 */
package org.robovm.compiler.plugin.lambda;

import java.util.ArrayList;
import java.util.List;
import org.objectweb.asm.ClassWriter;
import org.objectweb.asm.MethodVisitor;
import org.objectweb.asm.commons.GeneratorAdapter;
import org.robovm.compiler.CompilerException;
import org.robovm.compiler.Types;
import org.robovm.compiler.plugin.lambda.LambdaClass;
import soot.DoubleType;
import soot.FloatType;
import soot.LongType;
import soot.PrimType;
import soot.RefType;
import soot.SootClass;
import soot.SootMethodHandle;
import soot.SootMethodRef;
import soot.SootMethodType;
import soot.Type;
import soot.VoidType;

public class LambdaClassGenerator {
    private static int CLASS_VERSION = 51;
    private int counter = 1;

    public LambdaClass generate(SootClass caller, String invokedName, SootMethodRef invokedType, SootMethodType samMethodType, SootMethodHandle implMethod, SootMethodType instantiatedMethodType, List<Type> markerInterfaces, List<SootMethodType> bridgeMethods) {
        ClassWriter cw = new ClassWriter(3);
        String lambdaClassName = caller.getName().replace('.', '/') + "$$Lambda$" + this.counter++;
        String functionalInterface = invokedType.returnType().toString().replace('.', '/');
        ArrayList<String> interfaces = new ArrayList<String>();
        interfaces.add(functionalInterface);
        for (Type markerInterface : markerInterfaces) {
            interfaces.add(markerInterface.toString().replace('.', '/'));
        }
        cw.visit(CLASS_VERSION, 4144, lambdaClassName, null, "java/lang/Object", interfaces.toArray(new String[interfaces.size()]));
        String targetMethod = "<init>";
        this.createFieldsAndConstructor(lambdaClassName, cw, invokedType, samMethodType, implMethod, instantiatedMethodType);
        if (!invokedType.parameterTypes().isEmpty()) {
            targetMethod = this.createFactory(lambdaClassName, cw, invokedType, samMethodType, implMethod, instantiatedMethodType);
        }
        this.createForwardingMethod(caller, lambdaClassName, cw, invokedName, samMethodType.getParameterTypes(), samMethodType.getReturnType(), invokedType.parameterTypes(), samMethodType, implMethod, instantiatedMethodType, false);
        for (SootMethodType bridgeMethod : bridgeMethods) {
            this.createForwardingMethod(caller, lambdaClassName, cw, invokedName, bridgeMethod.getParameterTypes(), bridgeMethod.getReturnType(), invokedType.parameterTypes(), samMethodType, implMethod, instantiatedMethodType, true);
        }
        cw.visitEnd();
        return new LambdaClass(lambdaClassName, cw.toByteArray(), targetMethod, invokedType.parameterTypes(), invokedType.returnType());
    }

    private void createForwardingMethod(SootClass caller, String lambdaClassName, ClassWriter cw, String name, List<Type> parameters, Type returnType, List<Type> invokedParameters, SootMethodType samMethodType, SootMethodHandle implMethod, SootMethodType instantiatedMethodType, boolean isBridgeMethod) {
        String descriptor = Types.getDescriptor(parameters, returnType);
        String implClassName = implMethod.getMethodRef().declaringClass().getName().replace('.', '/');
        int accessFlags = 1 | (isBridgeMethod ? 64 : 0);
        MethodVisitor mv = cw.visitMethod(accessFlags, name, descriptor, null, null);
        mv.visitCode();
        int invokeOpCode = 184;
        boolean isInstanceMethod = false;
        switch (implMethod.getReferenceKind()) {
            case 9: {
                invokeOpCode = 185;
                isInstanceMethod = true;
                break;
            }
            case 7: {
                invokeOpCode = 183;
                isInstanceMethod = true;
                break;
            }
            case 8: {
                invokeOpCode = 183;
                break;
            }
            case 6: {
                invokeOpCode = 184;
                break;
            }
            case 5: {
                invokeOpCode = 182;
                isInstanceMethod = true;
                break;
            }
            default: {
                throw new CompilerException("Unknown invoke type: " + implMethod.getReferenceKind());
            }
        }
        GeneratorAdapter caster = new GeneratorAdapter(mv, accessFlags, name, descriptor);
        this.pushArguments(caller, lambdaClassName, mv, caster, parameters, invokedParameters, implMethod, instantiatedMethodType, isInstanceMethod);
        String implDescriptor = null;
        ArrayList<Type> paramTypes = new ArrayList<Type>(implMethod.getMethodType().getParameterTypes());
        if (isInstanceMethod) {
            paramTypes.remove(0);
        }
        implDescriptor = Types.getDescriptor(paramTypes, implMethod.getMethodType().getReturnType());
        mv.visitMethodInsn(invokeOpCode, implClassName, implMethod.getMethodRef().name(), implDescriptor, invokeOpCode == 185);
        this.createForwardingMethodReturn(mv, caster, returnType, samMethodType, implMethod, instantiatedMethodType);
        mv.visitMaxs(-1, -1);
        mv.visitEnd();
    }

    private void pushArguments(SootClass caller, String lambdaClassName, MethodVisitor mv, GeneratorAdapter caster, List<Type> parameters, List<Type> invokedParameters, SootMethodHandle implMethod, SootMethodType instantiatedMethodType, boolean isInstanceMethod) {
        if (implMethod.getReferenceKind() == 8) {
            mv.visitTypeInsn(187, implMethod.getMethodRef().declaringClass().getName().replace('.', '/'));
            mv.visitInsn(89);
        }
        for (int i = 0; i < invokedParameters.size(); ++i) {
            Type obj;
            Type captureType = obj = invokedParameters.get(i);
            mv.visitVarInsn(25, 0);
            mv.visitFieldInsn(180, lambdaClassName, "arg$" + (i + 1), Types.getDescriptor(captureType));
        }
        boolean paramsContainReceiver = isInstanceMethod && parameters.size() > implMethod.getMethodRef().parameterTypes().size();
        int paramsIndex = 0;
        int localIndex = 1;
        if (paramsContainReceiver && !parameters.isEmpty()) {
            Type param = parameters.get(0);
            mv.visitVarInsn(this.loadOpcodeForType(param), localIndex);
            this.castOrWiden(mv, caster, param, implMethod.getMethodRef().declaringClass().getType());
            localIndex += this.slotsForType(param);
            ++paramsIndex;
        }
        int samParamsOffset = implMethod.getMethodRef().parameterTypes().size() - parameters.size() + (paramsContainReceiver ? 1 : 0);
        int i = 0;
        while (paramsIndex < parameters.size()) {
            Type param = parameters.get(paramsIndex);
            mv.visitVarInsn(this.loadOpcodeForType(param), localIndex);
            this.castOrWiden(mv, caster, param, (Type)implMethod.getMethodRef().parameterTypes().get(samParamsOffset + i));
            localIndex += this.slotsForType(param);
            ++paramsIndex;
            ++i;
        }
    }

    private void castOrWiden(MethodVisitor mv, GeneratorAdapter caster, Type actual, Type expected) {
        if (actual.equals(expected)) {
            return;
        }
        if (actual.equals(VoidType.v()) || expected.equals(VoidType.v())) {
            return;
        }
        if ((this.isPrimitiveType(actual) || this.isBoxedType(actual)) && (this.isPrimitiveType(expected) || this.isBoxedType(expected))) {
            org.objectweb.asm.Type actualAsmType = this.getAsmPrimitiveType(actual);
            org.objectweb.asm.Type expectedAsmType = this.getAsmPrimitiveType(expected);
            if (this.isBoxedType(actual)) {
                caster.unbox(actualAsmType);
            }
            caster.cast(actualAsmType, expectedAsmType);
            if (this.isBoxedType(expected)) {
                caster.box(expectedAsmType);
            }
        } else if (this.isPrimitiveType(expected) && actual instanceof RefType) {
            caster.unbox(this.getAsmPrimitiveType(expected));
        } else if (this.isPrimitiveType(actual) && expected instanceof RefType) {
            caster.box(this.getAsmPrimitiveType(actual));
        } else {
            mv.visitTypeInsn(192, Types.getInternalName(expected));
        }
    }

    private org.objectweb.asm.Type getAsmPrimitiveType(Type type) {
        if (this.isBoxedType(type)) {
            String className = type.toString();
            if ("java.lang.Boolean".equals(className)) {
                return org.objectweb.asm.Type.BOOLEAN_TYPE;
            }
            if ("java.lang.Byte".equals(className)) {
                return org.objectweb.asm.Type.BYTE_TYPE;
            }
            if ("java.lang.Character".equals(className)) {
                return org.objectweb.asm.Type.CHAR_TYPE;
            }
            if ("java.lang.Short".equals(className)) {
                return org.objectweb.asm.Type.SHORT_TYPE;
            }
            if ("java.lang.Integer".equals(className)) {
                return org.objectweb.asm.Type.INT_TYPE;
            }
            if ("java.lang.Long".equals(className)) {
                return org.objectweb.asm.Type.LONG_TYPE;
            }
            if ("java.lang.Float".equals(className)) {
                return org.objectweb.asm.Type.FLOAT_TYPE;
            }
            if ("java.lang.Double".equals(className)) {
                return org.objectweb.asm.Type.DOUBLE_TYPE;
            }
            throw new CompilerException("Unknown primitive type " + type);
        }
        return org.objectweb.asm.Type.getType(Types.getDescriptor(type));
    }

    private boolean isPrimitiveType(Type type) {
        return type instanceof PrimType;
    }

    private boolean isBoxedType(Type type) {
        String className = type.toString();
        return "java.lang.Boolean".equals(className) || "java.lang.Byte".equals(className) || "java.lang.Character".equals(className) || "java.lang.Short".equals(className) || "java.lang.Integer".equals(className) || "java.lang.Long".equals(className) || "java.lang.Float".equals(className) || "java.lang.Double".equals(className);
    }

    private void createForwardingMethodReturn(MethodVisitor mv, GeneratorAdapter caster, Type returnType, SootMethodType samMethodType, SootMethodHandle implMethod, SootMethodType instantiatedMethodType) {
        this.castOrWiden(mv, caster, implMethod.getMethodRef().returnType(), instantiatedMethodType.getReturnType());
        if (returnType.equals(VoidType.v())) {
            mv.visitInsn(177);
        } else if (returnType instanceof PrimType) {
            if (returnType.equals(LongType.v())) {
                mv.visitInsn(173);
            } else if (returnType.equals(FloatType.v())) {
                mv.visitInsn(174);
            } else if (returnType.equals(DoubleType.v())) {
                mv.visitInsn(175);
            } else {
                mv.visitInsn(172);
            }
        } else {
            mv.visitInsn(176);
        }
    }

    private void createFieldsAndConstructor(String lambdaClassName, ClassWriter cw, SootMethodRef invokedType, SootMethodType samMethodType, SootMethodHandle implMethod, SootMethodType instantiatedMethodType) {
        StringBuffer constructorDescriptor = new StringBuffer();
        int i = 0;
        for (Object obj : invokedType.parameterTypes()) {
            Type captureType = (Type)obj;
            String typeDesc = Types.getDescriptor(captureType);
            cw.visitField(18, "arg$" + (i + 1), typeDesc, null, null);
            constructorDescriptor.append(typeDesc);
            ++i;
        }
        MethodVisitor mv = cw.visitMethod(0, "<init>", "(" + constructorDescriptor.toString() + ")V", null, null);
        mv.visitCode();
        mv.visitVarInsn(25, 0);
        mv.visitMethodInsn(183, "java/lang/Object", "<init>", "()V", false);
        i = 0;
        int localIndex = 1;
        for (Object obj : invokedType.parameterTypes()) {
            Type captureType = (Type)obj;
            mv.visitVarInsn(25, 0);
            mv.visitVarInsn(this.loadOpcodeForType(captureType), localIndex);
            localIndex += this.slotsForType(captureType);
            mv.visitFieldInsn(181, lambdaClassName, "arg$" + (i + 1), Types.getDescriptor(captureType));
            ++i;
        }
        mv.visitInsn(177);
        mv.visitMaxs(-1, -1);
        mv.visitEnd();
    }

    private String createFactory(String lambdaClassName, ClassWriter cw, SootMethodRef invokedType, SootMethodType samMethodType, SootMethodHandle implMethod, SootMethodType instantiatedMethodType) {
        MethodVisitor mv = cw.visitMethod(8, "get$Lambda", Types.getDescriptor(invokedType.parameterTypes(), invokedType.returnType()), null, null);
        mv.visitCode();
        mv.visitTypeInsn(187, lambdaClassName);
        mv.visitInsn(89);
        int i = 0;
        for (Object obj : invokedType.parameterTypes()) {
            Type captureType = (Type)obj;
            mv.visitVarInsn(this.loadOpcodeForType(captureType), i);
            i += this.slotsForType(captureType);
        }
        mv.visitMethodInsn(183, lambdaClassName, "<init>", Types.getDescriptor(invokedType.parameterTypes(), VoidType.v()), false);
        mv.visitInsn(176);
        mv.visitMaxs(-1, -1);
        mv.visitEnd();
        return "get$Lambda";
    }

    public int loadOpcodeForType(Type type) {
        if (type instanceof PrimType) {
            if (type.equals(LongType.v())) {
                return 22;
            }
            if (type.equals(FloatType.v())) {
                return 23;
            }
            if (type.equals(DoubleType.v())) {
                return 24;
            }
            return 21;
        }
        return 25;
    }

    public int slotsForType(Type type) {
        if (type.equals(LongType.v()) || type.equals(DoubleType.v())) {
            return 2;
        }
        return 1;
    }
}

