/*
 * Decompiled with CFR 0.152.
 */
package org.robovm.debugger.delegates;

import org.robovm.debugger.DebuggerException;
import org.robovm.debugger.delegates.AllDelegates;
import org.robovm.debugger.jdwp.handlers.thread.IJdwpThreadDelegate;
import org.robovm.debugger.state.instances.VmStackTrace;
import org.robovm.debugger.state.instances.VmThread;

public class ThreadDelegate
implements IJdwpThreadDelegate {
    private final AllDelegates delegates;
    private boolean vmResumed;

    public ThreadDelegate(AllDelegates delegates) {
        this.delegates = delegates;
    }

    @Override
    public void jdwpSuspendThread(long threadId) throws DebuggerException {
        VmThread thread = this.getThread(threadId);
        if (thread == null) {
            throw new DebuggerException(10);
        }
        this.suspendThread(thread);
    }

    public void suspendThread(VmThread thread) throws DebuggerException {
        int suspendCount = thread.markSuspended();
        if (suspendCount == 1) {
            this.delegates.hooksApi().threadSuspend(thread.threadPtr());
            thread.setStatus(VmThread.Status.SUSPENDED);
        }
    }

    @Override
    public void jdwpResumeThread(long threadId) throws DebuggerException {
        VmThread thread = this.getThread(threadId);
        this.resumeThread(thread);
    }

    public void resumeThread(VmThread thread) throws DebuggerException {
        int suspendCount = thread.suspendCount();
        thread.markResumed();
        if (suspendCount == 1) {
            this.delegates.events().restepBeforeResume(thread);
            this.delegates.hooksApi().threadResume(thread.threadPtr());
            thread.setStatus(VmThread.Status.RUNNING);
            this.setThreadStack(thread, null);
        }
    }

    @Override
    public void jdwpSuspendAllThreads() {
        for (VmThread thread : this.delegates.state().threads()) {
            this.suspendThread(thread);
        }
    }

    @Override
    public void jdwpResumeAllThreads() {
        if (!this.vmResumed) {
            this.vmResumed = true;
            this.delegates.hooksApi().threadResume(0L);
        }
        for (VmThread thread : this.delegates.state().threads()) {
            this.resumeThread(thread);
        }
    }

    public void onThreadSuspended(VmThread thread, VmStackTrace[] stack, boolean keepSuspended) {
        if (keepSuspended) {
            this.setThreadStack(thread, stack);
            thread.markSuspended();
            thread.setStatus(VmThread.Status.SUSPENDED);
        } else if (thread.suspendCount() == 0) {
            this.delegates.hooksApi().threadResume(thread.threadPtr());
        } else {
            this.setThreadStack(thread, stack);
        }
    }

    private VmThread getThread(long threadId) {
        VmThread thread;
        try {
            thread = (VmThread)this.delegates.state().referenceRefIdHolder().instanceById(threadId);
        }
        catch (ClassCastException e) {
            throw new DebuggerException(10);
        }
        if (thread == null) {
            throw new DebuggerException(20);
        }
        return thread;
    }

    private void setThreadStack(VmThread thread, VmStackTrace[] stack) {
        VmStackTrace[] oldStack = thread.stack();
        if (oldStack != null) {
            for (VmStackTrace trace : oldStack) {
                this.delegates.state().frameRefIdHolder().removeObject(trace);
            }
        }
        if (stack != null) {
            for (VmStackTrace trace : stack) {
                this.delegates.state().frameRefIdHolder().addObject(trace);
            }
        }
        thread.setStack(stack);
    }

    public void suspendAllOtherThreads(VmThread stoppedThread) {
        for (VmThread thread : this.delegates.state().threads()) {
            if (thread == stoppedThread) continue;
            this.suspendThread(thread);
        }
    }

    public void resumeAllOtherThreads(VmThread stoppedThread) {
        for (VmThread thread : this.delegates.state().threads()) {
            if (thread == stoppedThread) continue;
            this.resumeThread(thread);
        }
    }

    public VmThread anySuspendedThread() {
        for (VmThread thread : this.delegates.state().threads()) {
            if (thread.status() != VmThread.Status.SUSPENDED) continue;
            return thread;
        }
        return null;
    }

    public boolean isVmResumed() {
        return this.vmResumed;
    }
}

